/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.BlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithIV;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;

final class BcTlsBlockCipherImpl
implements TlsBlockCipherImpl {
    private final boolean isEncrypting;
    private final BlockCipher cipher;
    private KeyParameter key;

    BcTlsBlockCipherImpl(BlockCipher cipher, boolean isEncrypting) {
        this.cipher = cipher;
        this.isEncrypting = isEncrypting;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new KeyParameter(key, keyOff, keyLen);
    }

    @Override
    public void init(byte[] iv, int ivOff, int ivLen) {
        this.cipher.init(this.isEncrypting, new ParametersWithIV(this.key, iv, ivOff, ivLen));
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        int blockSize = this.cipher.getBlockSize();
        int i = 0;
        while (i < inputLength) {
            this.cipher.processBlock(input, inputOffset + i, output, outputOffset + i);
            i += blockSize;
        }
        return inputLength;
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

