/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.agreement.DHBasicAgreement;
import cn.win_trust_erpc.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsDHUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.DHGroup;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsAgreement;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsDHConfig;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsDHDomain;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsDH;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import cn.win_trust_erpc.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsDHDomain
implements TlsDHDomain {
    protected BcTlsCrypto crypto;
    protected TlsDHConfig dhConfig;
    protected DHParameters dhParameters;

    private static byte[] encodeValue(DHParameters dh, boolean padded, BigInteger x) {
        return padded ? BigIntegers.asUnsignedByteArray(BcTlsDHDomain.getValueLength(dh), x) : BigIntegers.asUnsignedByteArray(x);
    }

    private static int getValueLength(DHParameters dh) {
        return (dh.getP().bitLength() + 7) / 8;
    }

    public static BcTlsSecret calculateDHAgreement(BcTlsCrypto crypto, DHPrivateKeyParameters privateKey, DHPublicKeyParameters publicKey, boolean padded) {
        DHBasicAgreement basicAgreement = new DHBasicAgreement();
        basicAgreement.init(privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement(publicKey);
        byte[] secret = BcTlsDHDomain.encodeValue(privateKey.getParameters(), padded, agreementValue);
        return crypto.adoptLocalSecret(secret);
    }

    public static DHParameters getParameters(TlsDHConfig dhConfig) {
        DHGroup dhGroup = TlsDHUtils.getDHGroup(dhConfig);
        if (dhGroup == null) {
            throw new IllegalArgumentException("No DH configuration provided");
        }
        return new DHParameters(dhGroup.getP(), dhGroup.getG(), dhGroup.getQ(), dhGroup.getL());
    }

    public BcTlsDHDomain(BcTlsCrypto crypto, TlsDHConfig dhConfig) {
        this.crypto = crypto;
        this.dhConfig = dhConfig;
        this.dhParameters = BcTlsDHDomain.getParameters(dhConfig);
    }

    public BcTlsSecret calculateDHAgreement(DHPrivateKeyParameters privateKey, DHPublicKeyParameters publicKey) {
        return BcTlsDHDomain.calculateDHAgreement(this.crypto, privateKey, publicKey, this.dhConfig.isPadded());
    }

    @Override
    public TlsAgreement createDH() {
        return new BcTlsDH(this);
    }

    public BigInteger decodeParameter(byte[] encoding) throws IOException {
        if (this.dhConfig.isPadded() && BcTlsDHDomain.getValueLength(this.dhParameters) != encoding.length) {
            throw new TlsFatalAlert(47);
        }
        return new BigInteger(1, encoding);
    }

    public DHPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            BigInteger y = this.decodeParameter(encoding);
            return new DHPublicKeyParameters(y, this.dhParameters);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(40, (Throwable)e);
        }
    }

    public byte[] encodeParameter(BigInteger x) throws IOException {
        return BcTlsDHDomain.encodeValue(this.dhParameters, this.dhConfig.isPadded(), x);
    }

    public byte[] encodePublicKey(DHPublicKeyParameters publicKey) throws IOException {
        return BcTlsDHDomain.encodeValue(this.dhParameters, true, publicKey.getY());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHBasicKeyPairGenerator keyPairGenerator = new DHBasicKeyPairGenerator();
        keyPairGenerator.init(new DHKeyGenerationParameters(this.crypto.getSecureRandom(), this.dhParameters));
        return keyPairGenerator.generateKeyPair();
    }
}

