/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.DSA;
import cn.win_trust_erpc.bouncycastle.crypto.digests.NullDigest;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.signers.DSADigestSigner;
import cn.win_trust_erpc.bouncycastle.tls.DigitallySigned;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public abstract class BcTlsDSSVerifier
extends BcTlsVerifier {
    protected BcTlsDSSVerifier(TlsCrypto crypto, AsymmetricKeyParameter publicKey) {
        super(crypto, publicKey);
    }

    protected abstract DSA createDSAImpl(int var1);

    protected abstract short getSignatureAlgorithm();

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int cryptoHashAlgorithm = algorithm == null ? 2 : TlsCryptoUtils.getHash(algorithm.getHash());
        DSADigestSigner signer = new DSADigestSigner(this.createDSAImpl(cryptoHashAlgorithm), new NullDigest());
        signer.init(false, this.publicKey);
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.verifySignature(signedParams.getSignature());
    }
}

