/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.DigitallySigned;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureScheme;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamVerifier;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsVerifier;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class JcaTlsRSAPSSVerifier
implements TlsVerifier {
    private final TlsCrypto crypto;
    private final PublicKey publicKey;
    private final int signatureScheme;

    public JcaTlsRSAPSSVerifier(TlsCrypto crypto, PublicKey publicKey, int signatureScheme) {
        if (crypto == null) {
            throw new NullPointerException("crypto");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey");
        }
        if (!SignatureScheme.isRSAPSS(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.crypto = crypto;
        this.publicKey = publicKey;
        this.signatureScheme = signatureScheme;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) throws IOException {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        String digestName = this.crypto.getDigestName(cryptoHashAlgorithm);
        String sigName = String.valueOf(RSAUtil.getDigestSigAlgName(digestName)) + "WITHRSAANDMGF1";
        AlgorithmParameterSpec pssSpec = RSAUtil.getPSSParameterSpec(cryptoHashAlgorithm, digestName, this.crypto.getHelper());
        return this.crypto.createStreamVerifier(sigName, pssSpec, signature.getSignature(), this.publicKey);
    }
}

