/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.HashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.util.Strings;
import java.security.Provider;
import java.security.Security;

class JcaUtils {
    JcaUtils() {
    }

    static String getJcaAlgorithmName(SignatureAndHashAlgorithm algorithm) {
        return String.valueOf(HashAlgorithm.getName(algorithm.getHash())) + "WITH" + Strings.toUpperCase(SignatureAlgorithm.getName(algorithm.getSignature()));
    }

    static boolean isSunMSCAPIProviderActive() {
        return Security.getProvider("SunMSCAPI") != null;
    }

    static boolean isSunMSCAPIProvider(Provider provider) {
        return provider != null && JcaUtils.isSunMSCAPIProviderName(provider.getName());
    }

    static boolean isSunMSCAPIProviderName(String providerName) {
        return "SunMSCAPI".equals(providerName);
    }
}

