/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsAgreement;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JceX25519Domain;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;

public class JceX25519
implements TlsAgreement {
    protected final JceX25519Domain domain;
    protected KeyPair localKeyPair;
    protected PublicKey peerPublicKey;

    public JceX25519(JceX25519Domain domain) {
        this.domain = domain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey(this.localKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(peerValue);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        return this.domain.calculateECDHAgreement(this.localKeyPair.getPrivate(), this.peerPublicKey);
    }
}

