/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import junit.framework.TestCase;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.test.DTLSTestClientProtocol;
import org.bouncycastle.tls.test.DTLSTestServerProtocol;
import org.bouncycastle.tls.test.MockDatagramAssociation;
import org.bouncycastle.tls.test.TlsTestClientImpl;
import org.bouncycastle.tls.test.TlsTestConfig;
import org.bouncycastle.tls.test.TlsTestServerImpl;
import org.bouncycastle.util.Arrays;

public class DTLSTestCase
extends TestCase {
    protected final TlsTestConfig config;

    private static void checkDTLSVersion(ProtocolVersion version) {
        if (version != null && !version.isDTLS()) {
            throw new IllegalStateException("Non-DTLS version");
        }
    }

    public DTLSTestCase(String name) {
        super(name);
        this.config = null;
    }

    public DTLSTestCase(TlsTestConfig config, String name) {
        super(name);
        DTLSTestCase.checkDTLSVersion(config.clientMinimumVersion);
        DTLSTestCase.checkDTLSVersion(config.clientOfferVersion);
        DTLSTestCase.checkDTLSVersion(config.serverMaximumVersion);
        DTLSTestCase.checkDTLSVersion(config.serverMinimumVersion);
        this.config = config;
    }

    public void testDummy() {
    }

    protected void runTest() throws Throwable {
        if (this.config == null) {
            return;
        }
        DTLSTestClientProtocol clientProtocol = new DTLSTestClientProtocol(this.config);
        DTLSTestServerProtocol serverProtocol = new DTLSTestServerProtocol(this.config);
        MockDatagramAssociation network = new MockDatagramAssociation(1500);
        TlsTestClientImpl clientImpl = new TlsTestClientImpl(this.config);
        TlsTestServerImpl serverImpl = new TlsTestServerImpl(this.config);
        ServerThread serverThread = new ServerThread(serverProtocol, network.getServer(), serverImpl);
        serverThread.start();
        Exception caught = null;
        try {
            DatagramTransport clientTransport = network.getClient();
            DTLSTransport dtlsClient = clientProtocol.connect(clientImpl, clientTransport);
            for (int i = 1; i <= 10; ++i) {
                byte[] data = new byte[i];
                Arrays.fill((byte[])data, (byte)((byte)i));
                dtlsClient.send(data, 0, data.length);
            }
            byte[] buf = new byte[dtlsClient.getReceiveLimit()];
            while (dtlsClient.receive(buf, 0, buf.length, 100) >= 0) {
            }
            dtlsClient.close();
        }
        catch (Exception e) {
            caught = e;
            this.logException(caught);
        }
        serverThread.shutdown();
        DTLSTestCase.assertEquals((String)"Client fatal alert connection end", (int)this.config.expectFatalAlertConnectionEnd, (int)clientImpl.firstFatalAlertConnectionEnd);
        DTLSTestCase.assertEquals((String)"Server fatal alert connection end", (int)this.config.expectFatalAlertConnectionEnd, (int)serverImpl.firstFatalAlertConnectionEnd);
        DTLSTestCase.assertEquals((String)"Client fatal alert description", (short)this.config.expectFatalAlertDescription, (short)clientImpl.firstFatalAlertDescription);
        DTLSTestCase.assertEquals((String)"Server fatal alert description", (short)this.config.expectFatalAlertDescription, (short)serverImpl.firstFatalAlertDescription);
        if (this.config.expectFatalAlertConnectionEnd == -1) {
            DTLSTestCase.assertNull((String)"Unexpected client exception", (Object)caught);
            DTLSTestCase.assertNull((String)"Unexpected server exception", (Object)serverThread.caught);
        }
    }

    protected void logException(Exception e) {
    }

    class ServerThread
    extends Thread {
        private final DTLSTestServerProtocol serverProtocol;
        private final DatagramTransport serverTransport;
        private final TlsTestServerImpl serverImpl;
        private volatile boolean isShutdown = false;
        Exception caught = null;

        ServerThread(DTLSTestServerProtocol serverProtocol, DatagramTransport serverTransport, TlsTestServerImpl serverImpl) {
            this.serverProtocol = serverProtocol;
            this.serverTransport = serverTransport;
            this.serverImpl = serverImpl;
        }

        @Override
        public void run() {
            try {
                DTLSTransport dtlsServer = this.serverProtocol.accept(this.serverImpl, this.serverTransport);
                byte[] buf = new byte[dtlsServer.getReceiveLimit()];
                while (!this.isShutdown) {
                    int length = dtlsServer.receive(buf, 0, buf.length, 100);
                    if (length < 0) continue;
                    dtlsServer.send(buf, 0, length);
                }
                dtlsServer.close();
            }
            catch (Exception e) {
                this.caught = e;
                DTLSTestCase.this.logException(this.caught);
            }
        }

        void shutdown() throws InterruptedException {
            if (!this.isShutdown) {
                this.isShutdown = true;
                this.interrupt();
                this.join();
            }
        }
    }
}

