/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import org.bouncycastle.tls.test.TlsTestConfig;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;

class TlsTestClientImpl
extends DefaultTlsClient {
    protected final TlsTestConfig config;
    protected int firstFatalAlertConnectionEnd = -1;
    protected short firstFatalAlertDescription = (short)-1;
    byte[] tlsUnique = null;

    TlsTestClientImpl(TlsTestConfig config) {
        super(new BcTlsCrypto(new SecureRandom()));
        this.config = config;
    }

    int getFirstFatalAlertConnectionEnd() {
        return this.firstFatalAlertConnectionEnd;
    }

    short getFirstFatalAlertDescription() {
        return this.firstFatalAlertDescription;
    }

    @Override
    public TlsCrypto getCrypto() {
        switch (this.config.clientCrypto) {
            case 1: {
                return new JcaTlsCryptoProvider().setProvider((Provider)new BouncyCastleProvider()).create(new SecureRandom(), new SecureRandom());
            }
        }
        return new BcTlsCrypto(new SecureRandom());
    }

    @Override
    public ProtocolVersion getClientVersion() {
        if (this.config.clientOfferVersion != null) {
            return this.config.clientOfferVersion;
        }
        return super.getClientVersion();
    }

    @Override
    public ProtocolVersion getMinimumVersion() {
        if (this.config.clientMinimumVersion != null) {
            return this.config.clientMinimumVersion;
        }
        return super.getMinimumVersion();
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = super.getClientExtensions();
        if (clientExtensions != null && !this.config.clientSendSignatureAlgorithms) {
            clientExtensions.remove(TlsUtils.EXT_signature_algorithms);
            this.supportedSignatureAlgorithms = null;
        }
        return clientExtensions;
    }

    @Override
    public boolean isFallback() {
        return this.config.clientFallback;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 1;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 0;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.tlsUnique = this.context.exportChannelBinding(1);
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        super.notifyServerVersion(serverVersion);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                boolean isEmpty;
                TlsCertificate[] chain = serverCertificate.getCertificate().getCertificateList();
                boolean bl = isEmpty = serverCertificate == null || serverCertificate.getCertificate() == null || serverCertificate.getCertificate().isEmpty();
                if (isEmpty || !TlsTestUtils.isCertificateOneOf(TlsTestClientImpl.this.context.getCrypto(), chain[0], new String[]{"x509-server-dsa.pem", "x509-server-ecdsa.pem", "x509-server-rsa-enc.pem", "x509-server-rsa-sign.pem"})) {
                    throw new TlsFatalAlert(42);
                }
            }

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                if (TlsTestClientImpl.this.config.serverCertReq == 0) {
                    throw new IllegalStateException();
                }
                if (TlsTestClientImpl.this.config.clientAuth == 0) {
                    return null;
                }
                short[] certificateTypes = certificateRequest.getCertificateTypes();
                if (certificateTypes == null || !Arrays.contains((short[])certificateTypes, (short)1)) {
                    return null;
                }
                Vector<SignatureAndHashAlgorithm> supportedSigAlgs = certificateRequest.getSupportedSignatureAlgorithms();
                if (supportedSigAlgs != null && TlsTestClientImpl.this.config.clientAuthSigAlg != null) {
                    supportedSigAlgs = new Vector<SignatureAndHashAlgorithm>(1);
                    supportedSigAlgs.addElement(TlsTestClientImpl.this.config.clientAuthSigAlg);
                }
                final TlsCredentialedSigner signerCredentials = TlsTestUtils.loadSignerCredentials(TlsTestClientImpl.this.context, supportedSigAlgs, (short)1, "x509-client-rsa.pem", "x509-client-key-rsa.pem");
                if (TlsTestClientImpl.this.config.clientAuth == 1) {
                    return signerCredentials;
                }
                return new TlsCredentialedSigner(){

                    @Override
                    public byte[] generateRawSignature(byte[] hash) throws IOException {
                        byte[] sig = signerCredentials.generateRawSignature(hash);
                        if (TlsTestClientImpl.this.config.clientAuth == 3) {
                            sig = TlsTestClientImpl.this.corruptBit(sig);
                        }
                        return sig;
                    }

                    @Override
                    public Certificate getCertificate() {
                        Certificate cert = signerCredentials.getCertificate();
                        if (TlsTestClientImpl.this.config.clientAuth == 2) {
                            cert = TlsTestClientImpl.this.corruptCertificate(TlsTestClientImpl.this.context.getCrypto(), cert);
                        }
                        return cert;
                    }

                    @Override
                    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
                        return signerCredentials.getSignatureAndHashAlgorithm();
                    }

                    @Override
                    public TlsStreamSigner getStreamSigner() throws IOException {
                        return null;
                    }
                };
            }
        };
    }

    protected Certificate corruptCertificate(TlsCrypto crypto, Certificate cert) {
        TlsCertificate[] certList = cert.getCertificateList();
        try {
            certList[0] = this.corruptCertificateSignature(crypto, certList[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Certificate(certList);
    }

    protected TlsCertificate corruptCertificateSignature(TlsCrypto crypto, TlsCertificate tlsCertificate) throws IOException {
        org.bouncycastle.asn1.x509.Certificate cert = org.bouncycastle.asn1.x509.Certificate.getInstance((Object)tlsCertificate.getEncoded());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)cert.getTBSCertificate());
        v.add((ASN1Encodable)cert.getSignatureAlgorithm());
        v.add((ASN1Encodable)this.corruptSignature(cert.getSignature()));
        return crypto.createCertificate(org.bouncycastle.asn1.x509.Certificate.getInstance((Object)new DERSequence(v)).getEncoded("DER"));
    }

    protected DERBitString corruptSignature(DERBitString bs) {
        return new DERBitString(this.corruptBit(bs.getOctets()));
    }

    protected byte[] corruptBit(byte[] bs) {
        bs = Arrays.clone((byte[])bs);
        int bit = this.context.getCrypto().getSecureRandom().nextInt(bs.length << 3);
        int n = bit >>> 3;
        bs[n] = (byte)(bs[n] ^ 1 << (bit & 7));
        return bs;
    }
}

