/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.newcommunitor;

import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.newcommunitor.AgentCommunitor;
import cn.com.infosec.netsign.agent.newcommunitor.ThinCommunitor;
import java.util.ArrayList;

public class CommunitorPool {
    private ArrayList connections = new ArrayList();

    public CommunitorPool() {
        int i = 0;
        int size = NetSignAgentRes.getMaxPoolSize();
        while (i < size) {
            this.connections.add(new ThinCommunitor());
            ++i;
        }
    }

    public synchronized void freeCommunitor(AgentCommunitor comm) {
        if (this.connections.size() > NetSignAgentRes.getMaxPoolSize()) {
            comm.close();
        } else {
            this.connections.add(comm);
            this.notifyAll();
        }
    }

    public synchronized ThinCommunitor getCommunitor() {
        try {
            while (this.connections.size() == 0) {
                this.wait();
            }
            return (ThinCommunitor)this.connections.remove(this.connections.size() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        if (this.connections == null || this.connections.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int size = this.connections.size();
        while (i < size) {
            buf.append(String.valueOf(this.connections.get(i).toString()) + "\n");
            ++i;
        }
        return buf.toString();
    }
}

