/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.decoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.CompressionUtil;
import netbank.firm.decoder.DcfirmMessageToMessageDecoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;

public class UncompressDecoder
extends DcfirmMessageToMessageDecoder<Message> {
    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                MessageHead mh = (MessageHead)msg.getHead();
                if (mh.getCompress().booleanValue()) {
                    this.LOG.debug("\u89e3\u538b\u7f29\u5904\u7406");
                    byte[] body = msg.getBody();
                    body = CompressionUtil.decompress(body);
                    msg.setBody(body);
                    msg.getHead().setLength(body.length);
                } else {
                    this.LOG.debug("\u65e0\u9700\u89e3\u538b\u7f29\u5904\u7406");
                }
            }
            out.add(msg);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U106, (Throwable)e);
        }
    }
}

