/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.dispatcher;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.AbstractMessageHead;
import netbank.firm.model.BizType;
import netbank.firm.model.MagicNum;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;
import netbank.firm.model.ProtocolVersion;
import netbank.firm.model.SimpleHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderDispatcher
extends ReplayingDecoder<DecoderState> {
    protected static final Logger LOG = LoggerFactory.getLogger(DecoderDispatcher.class);
    private Message msg = null;
    private ProtocolVersion version;
    private MagicNum magic;
    private BizType bizType;
    private int length;
    private Boolean encrpt;
    private Boolean compress;
    private String md;
    private String key;
    private byte[] content;
    private MessageType mt;

    public DecoderDispatcher() {
        super((Object)DecoderState.READ_MAGIC);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((DecoderState)((Object)this.state())) {
            case READ_MAGIC: {
                this.magic = MagicNum.valueOf(in.readByte());
                switch (this.magic) {
                    case _0x12: {
                        this.checkpoint((Object)DecoderState.READ_VERSION);
                        this.mt = MessageType.MESSAGE;
                        break;
                    }
                    case _0x15: {
                        this.checkpoint((Object)DecoderState.READ_LENGTH);
                        this.mt = MessageType.FILE;
                        return;
                    }
                    case _0x13: 
                    case _0x14: {
                        this.checkpoint((Object)DecoderState.READ_VERSION);
                        this.mt = MessageType.MESSAGE;
                        break;
                    }
                    case _0x16: 
                    case _0x17: {
                        this.checkpoint((Object)DecoderState.READ_LENGTH);
                        this.mt = MessageType.FILE;
                        return;
                    }
                    case _0x18: {
                        this.checkpoint((Object)DecoderState.READ_LENGTH);
                        this.mt = MessageType.SYSERR;
                        return;
                    }
                    default: {
                        LOG.error("\u901a\u9053id\uff1a" + ctx.channel().id() + " \u9b54\u6570\u503c\uff1a" + Integer.toHexString(in.readByte() & 0xFF));
                        throw new DcfirmException(ExceptionCode.B100);
                    }
                }
            }
            case READ_VERSION: {
                this.version = ProtocolVersion.valueOf(in.readByte());
                if (this.version != ProtocolVersion.VER1) {
                    throw new DcfirmException(ExceptionCode.B100);
                }
                this.checkpoint((Object)DecoderState.READ_BIZ_TYPE);
            }
            case READ_BIZ_TYPE: {
                this.bizType = BizType.valueOf(in.readByte());
                if (this.bizType == BizType.UNSUPPORT) {
                    throw new DcfirmException(ExceptionCode.B101);
                }
                this.checkpoint((Object)DecoderState.READ_COMPRESS);
            }
            case READ_COMPRESS: {
                this.compress = in.readBoolean();
                this.checkpoint((Object)DecoderState.READ_ENCRPT);
            }
            case READ_ENCRPT: {
                this.encrpt = in.readBoolean();
                this.checkpoint((Object)DecoderState.READ_MD);
            }
            case READ_MD: {
                byte[] mdbytes = new byte[32];
                in.readBytes(mdbytes, 0, 32);
                this.md = new String(mdbytes);
                this.checkpoint((Object)DecoderState.READ_KEY);
            }
            case READ_KEY: {
                byte[] keybytes = new byte[16];
                in.readBytes(keybytes, 0, 16);
                this.key = new String(keybytes);
                this.checkpoint((Object)DecoderState.READ_LENGTH);
            }
            case READ_LENGTH: {
                this.length = in.readShort();
                this.checkpoint((Object)DecoderState.READ_CONTENT);
            }
            case READ_CONTENT: {
                this.content = new byte[this.length];
                in.readBytes(this.content, 0, this.length);
                AbstractMessageHead<?> head = this.newHead();
                this.msg = new Message(this.mt, head, this.content);
                break;
            }
        }
        this.reset();
        if (this.msg == null) {
            ctx.channel().closeFuture().sync();
            return;
        }
        out.add(this.msg);
    }

    private void reset() {
        this.magic = null;
        this.bizType = null;
        this.length = 0;
        this.encrpt = null;
        this.compress = null;
        this.md = null;
        this.content = null;
        this.mt = null;
        this.key = null;
        this.checkpoint((Object)DecoderState.READ_MAGIC);
    }

    private AbstractMessageHead<?> newHead() {
        switch (this.magic) {
            case _0x12: 
            case _0x13: 
            case _0x14: {
                MessageHead head = new MessageHead();
                head.setMagicNum(this.magic);
                head.setVersion(this.version);
                head.setBizType(this.bizType);
                head.setCompress(this.compress);
                head.setEncrypt(this.encrpt);
                head.setMd(this.md);
                head.setKey(this.key);
                head.setLength(this.length);
                return head;
            }
            case _0x15: 
            case _0x16: 
            case _0x17: 
            case _0x18: {
                SimpleHead head = new SimpleHead();
                head.setMagicNum(this.magic);
                head.setLength(this.length);
                return head;
            }
        }
        return null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error(cause.getMessage(), cause);
        ctx.close();
    }

    static enum DecoderState {
        READ_MAGIC,
        READ_VERSION,
        READ_BIZ_TYPE,
        READ_COMPRESS,
        READ_ENCRPT,
        READ_MD,
        READ_KEY,
        READ_LENGTH,
        READ_CONTENT;

    }
}

