/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.exception;

import netbank.firm.base.SystemProperty;
import netbank.firm.exception.ExceptionCode;

public class DcfirmException
extends Exception {
    private static final long serialVersionUID = 2750254028380665357L;
    private String code;
    private String message;

    public DcfirmException() {
        super(ExceptionCode.UNKNOWN.getErrmsg());
        this.code = ExceptionCode.UNKNOWN.getCode();
        this.message = ExceptionCode.UNKNOWN.getErrmsg();
    }

    public DcfirmException(ExceptionCode code) {
        super(code.getErrmsg());
        this.code = code.getCode();
        this.message = code.getErrmsg();
    }

    public DcfirmException(ExceptionCode code, Throwable throwable) {
        super(code.getErrmsg(), throwable);
        this.code = code.getCode();
        this.message = code.getErrmsg();
    }

    public DcfirmException(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public DcfirmException(String code, String message, Throwable throwable) {
        super(message, throwable);
        this.code = code;
        this.message = message;
    }

    public String getErrCode() {
        return SystemProperty.getInstance().getSysName() + "_" + this.code;
    }

    public String getErrmsg() {
        return this.message;
    }

    @Override
    public String toString() {
        return "DcfirmException code=[" + this.getErrCode() + "],error message=[" + this.message + "]";
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

