/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import netbank.firm.file.EnCode64;
import netbank.firm.file.SimpleIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    private static final String DATE_CATALOG_FORMAT = "yyyyMMdd";
    private static final String FILE_PATH_SEPARATOR = "/";
    private static final String FILE_NAME_SEPARATOR = "_";
    private static final String RECEIVE = "receive";
    private static final String SEND = "send";
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateFileId(String bizcode, String path) throws Exception {
        String catalog = FileUtils.getDateCatalog(null);
        String catalogPath = path + FILE_PATH_SEPARATOR + catalog + FILE_PATH_SEPARATOR + bizcode;
        String receivePath = catalogPath + FILE_PATH_SEPARATOR + RECEIVE;
        String sendPath = catalogPath + FILE_PATH_SEPARATOR + SEND;
        File receiveFile = new File(receivePath);
        File sendFile = new File(sendPath);
        Object object = lock;
        synchronized (object) {
            if (!receiveFile.exists() && !receiveFile.mkdirs()) {
                LOG.error("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55:" + receiveFile.getAbsolutePath() + " \u5931\u8d25!");
                throw new IOException("Failed to create directory '" + receiveFile.getAbsolutePath() + "'");
            }
            if (!sendFile.exists() && !sendFile.mkdirs()) {
                LOG.error("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55:" + sendFile.getAbsolutePath() + " \u5931\u8d25!");
                throw new IOException("Failed to create directory '" + sendFile.getAbsolutePath() + "'");
            }
        }
        return bizcode + SimpleIDGenerator.getSerialID();
    }

    public static File getFile4Receive(String path, String fileId, String fileName) throws Exception {
        File file = null;
        String catalog = FileUtils.getCatalogByFileId(fileId);
        String fullName = FileUtils.generateFileFullName(fileId, fileName);
        String filePath = path + FILE_PATH_SEPARATOR + catalog + FILE_PATH_SEPARATOR + RECEIVE + FILE_PATH_SEPARATOR + fullName;
        file = new File(filePath);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String restore4Send(String bizCode, File file, String path) throws Exception {
        String fileId = FileUtils.generateFileId(bizCode, path);
        File newFile = FileUtils.getFile4Send(path, fileId, file.getName());
        FileInputStream fi = null;
        FileOutputStream fo = null;
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            fi = new FileInputStream(file);
            in = fi.getChannel();
            fo = new FileOutputStream(newFile);
            out = fo.getChannel();
            in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            out.close();
            in.close();
            fo.close();
            fi.close();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (fo != null) {
                    fo.close();
                }
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileId;
    }

    public static File getFile4Send(String path, String fileId, String fileName) throws Exception {
        String catalog = FileUtils.getCatalogByFileId(fileId);
        String fullName = FileUtils.generateFileFullName(fileId, fileName);
        String filePath = path + FILE_PATH_SEPARATOR + catalog + FILE_PATH_SEPARATOR + SEND + FILE_PATH_SEPARATOR + fullName;
        return new File(filePath);
    }

    public static String getDateCatalog(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_CATALOG_FORMAT);
        date = date == null ? new Date() : date;
        return sdf.format(date);
    }

    public static String getCatalogByFileId(String fileId) throws Exception {
        if (fileId == null || fileId.length() != 15) {
            throw new Exception("FileID\u503c\u975e\u6cd5:" + fileId);
        }
        String bizCode = fileId.substring(0, 3);
        String timeStr = fileId.substring(5, 12);
        long time = EnCode64.UncompressNumber(timeStr);
        Calendar cd = Calendar.getInstance();
        cd.setTimeInMillis(time);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_CATALOG_FORMAT);
        return sdf.format(cd.getTime()) + FILE_PATH_SEPARATOR + bizCode;
    }

    public static String generateFileFullName(String fileId, String FileName) {
        return fileId + FILE_NAME_SEPARATOR + FileName;
    }

    public static String[] splitFullName(String fullName) throws Exception {
        if (fullName.indexOf(FILE_NAME_SEPARATOR) < 0) {
            throw new Exception("fullName\u503c\u975e\u6cd5\uff01");
        }
        return fullName.split(FILE_NAME_SEPARATOR);
    }

    public static void main(String[] args) throws Exception {
        String fullName = "10195V!cM8w48xj_logback.xml";
        String fileId = fullName.split(FILE_NAME_SEPARATOR)[0];
        System.out.println("fileID=" + FileUtils.getCatalogByFileId(fileId));
    }
}

