/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.enums;

import com.xwbank.sdk.strategy.ChannelStrategy;
import com.xwbank.sdk.strategy.impl.channel.Base64FileChannelStrategy;
import com.xwbank.sdk.strategy.impl.channel.CoreGMChannelStrategy;
import com.xwbank.sdk.strategy.impl.channel.FileChannelStrategy;
import com.xwbank.sdk.strategy.impl.channel.FileFormChannelStrategy;
import com.xwbank.sdk.strategy.impl.channel.NoticeChannelStrategy;
import com.xwbank.sdk.strategy.impl.channel.ServerGMChannelStrategy;
import com.xwbank.sdk.strategy.impl.channel.StandardGMChannelStrategy;
import javax.validation.constraints.NotNull;

public enum ChannelStrategyEnum {
    CHANNEL_GM_ENCRYPT_SIGN("standardGMNew", new StandardGMChannelStrategy()),
    CHANNEL_GM_FILE("GM_FILE", new FileChannelStrategy()),
    CHANNEL_GM_FILE_FORM_DATA("GM_FILE_FORM_DATA", new FileFormChannelStrategy()),
    CHANNEL_GM_FILE_BASE64("GM_FILE_BASE64", new Base64FileChannelStrategy()),
    CHANNEL_GM_NOTICE("GM_NOTICE", new NoticeChannelStrategy()),
    CHANNEL_GM_CORE("coreGMNew", new CoreGMChannelStrategy()),
    CHANNEL_GM_SERVER("serverGMNew", new ServerGMChannelStrategy());

    private final String channelType;
    private final ChannelStrategy channelStrategy;

    private ChannelStrategyEnum(String channelType, ChannelStrategy channelStrategy) {
        this.channelType = channelType;
        this.channelStrategy = channelStrategy;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public ChannelStrategy getChannelStrategy() {
        return this.channelStrategy;
    }

    public static ChannelStrategy getChannelStrategy(@NotNull String channelType) {
        ChannelStrategyEnum[] enums;
        for (ChannelStrategyEnum strategyEnum : enums = ChannelStrategyEnum.values()) {
            if (!strategyEnum.getChannelType().equalsIgnoreCase(channelType)) continue;
            return strategyEnum.getChannelStrategy();
        }
        return null;
    }
}

