/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.strategy.impl.channel;

import com.xwbank.sdk.config.ApplicationConfig;
import com.xwbank.sdk.constants.BaseUrlConstant;
import com.xwbank.sdk.exception.SDKException;
import com.xwbank.sdk.strategy.ChannelStrategy;
import com.xwbank.sdk.utils.GmUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerGMChannelStrategy
implements ChannelStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ServerGMChannelStrategy.class);

    @Override
    public Map<String, String> getHeaders(String appId, String idToken) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("accessType", "serverGMNew");
        headerMap.put("appID", appId);
        headerMap.put("idToken", idToken);
        headerMap.put("interfaceVersion", BaseUrlConstant.VERSION);
        return headerMap;
    }

    @Override
    public Map<String, Object> doRequest(Map<String, Object> params, ApplicationConfig config) throws SDKException {
        return GmUtil.serverSign(params, config.getPrivateKey());
    }

    @Override
    public Map<String, Object> doResponse(Map<String, Object> params, ApplicationConfig config) throws SDKException {
        return GmUtil.serverVerifySign(params, config.getPublicKey());
    }
}

