/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils;

import com.xwbank.sdk.exception.SDKException;
import com.xwbank.sdk.utils.DateUtils;
import com.xwbank.sdk.utils.JacksonUtil;
import com.xwbank.sdk.utils.StringUtils;
import com.xwbank.sdk.utils.sm.SM2Util;
import com.xwbank.sdk.utils.sm.SM4Util;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GmUtil {
    public static Map<String, Object> encryptAndSign(Map<String, Object> params, PublicKey publicKey, PrivateKey privateKey) throws SDKException {
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        sendMap.put("reqTime", DateUtils.formateCurrentDate());
        try {
            String pwd = SM4Util.getRandomStr(32);
            sendMap.put("ScrtKey", SM2Util.encrypt(publicKey, pwd));
            String sourceData = JacksonUtil.toJSONString(params);
            sendMap.put("data", SM4Util.encrypt(pwd.getBytes(StandardCharsets.UTF_8), sourceData));
            sourceData = GmUtil.sortString(sendMap);
            sendMap.put("sign", SM2Util.sign(privateKey, sourceData));
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", e);
        }
        return sendMap;
    }

    public static Map<String, Object> verifySignAndDecrypt(Map<String, Object> params, PublicKey publicKey, PrivateKey privateKey) throws SDKException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String sign = (String)params.remove("sign");
            String sortStr = GmUtil.sortString(params);
            if (!SM2Util.verifySign(publicKey, sortStr, sign)) {
                resultMap.put("returnCode", "110110");
                resultMap.put("returnMsg", "\u8fd4\u56de\u6570\u636e\uff0csdk\u9a8c\u7b7e\u5931\u8d25");
                return resultMap;
            }
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u9a8c\u7b7e\u5f02\u5e38", e);
        }
        try {
            String scrtKey = params.remove("ScrtKey").toString();
            byte[] bytesTxt = SM2Util.decrypt(privateKey, scrtKey.getBytes(StandardCharsets.UTF_8));
            String data = SM4Util.decrypt(bytesTxt, params.get("data").toString());
            params.put("data", data);
            return params;
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static Map<String, Object> noticeEncryptAndSign(Map<String, Object> params, PublicKey publicKey, PrivateKey privateKey) throws SDKException {
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        sendMap.put("respTime", DateUtils.formateCurrentDate());
        try {
            String pwd = SM4Util.getRandomStr(32);
            sendMap.put("ScrtKey", SM2Util.encrypt(publicKey, pwd));
            String sourceData = JacksonUtil.toJSONString(params);
            sendMap.put("data", SM4Util.encrypt(pwd.getBytes(StandardCharsets.UTF_8), sourceData));
            sourceData = GmUtil.sortString(sendMap);
            sendMap.put("sign", SM2Util.sign(privateKey, sourceData));
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", e);
        }
        return sendMap;
    }

    public static String sortString(Map<String, Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder linkStr = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = (String)params.get(key);
            if (value == null) continue;
            if (i == keys.size() - 1) {
                linkStr.append(key).append("=").append(value);
                continue;
            }
            linkStr.append(key).append("=").append(value).append("&");
        }
        return linkStr.toString();
    }

    public static Map<String, Object> serverSign(Map<String, Object> params, PrivateKey privateKey) throws SDKException {
        Map<String, Object> sendMap = JacksonUtil.toMap(JacksonUtil.toJSONString(params));
        try {
            sendMap.put("sign", SM2Util.sign(privateKey, GmUtil.serverLinkString(params)));
            return sendMap;
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u52a0\u7b7e\u5f02\u5e38", e);
        }
    }

    public static Map<String, Object> serverVerifySign(Map<String, Object> params, PublicKey publicKey) throws SDKException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String sign = (String)params.remove("sign");
            String sortStr = GmUtil.serverLinkString(params);
            if (!SM2Util.verifySign(publicKey, sortStr, sign)) {
                resultMap.put("returnCode", "110110");
                resultMap.put("returnMsg", "\u8fd4\u56de\u6570\u636e\uff0csdk\u9a8c\u7b7e\u5931\u8d25");
                return resultMap;
            }
            return params;
        }
        catch (Exception e) {
            throw new SDKException("\u62a5\u6587\u9a8c\u7b7e\u5f02\u5e38", e);
        }
    }

    public static String serverLinkString(Map<String, Object> params) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        GmUtil.getNeedMap(params, map);
        Map<String, String> tempMap = GmUtil.sortMapByKey(map);
        String dataStr = "";
        for (Map.Entry<String, String> entry : tempMap.entrySet()) {
            if (StringUtils.isBlank(entry.getValue())) continue;
            dataStr = dataStr.concat(entry.getKey()).concat("=").concat(entry.getValue()).concat("&");
        }
        return dataStr;
    }

    public static void getNeedMap(Map<String, Object> jsonObj, Map<String, String> map) throws Exception {
        for (Map.Entry<String, Object> entry : jsonObj.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Map) {
                Map Obj = (Map)object;
                GmUtil.getNeedMap(entry.getKey(), Obj, map);
                continue;
            }
            if (object instanceof List) {
                List jsonArray = (List)object;
                int size = jsonArray.size();
                for (int i = 0; i < size; ++i) {
                    Object arrayObject = jsonArray.get(i);
                    if (arrayObject instanceof String) {
                        map.put((String)arrayObject, (String)arrayObject);
                        continue;
                    }
                    if (!(arrayObject instanceof Map)) continue;
                    GmUtil.getNeedMap(entry.getKey(), (Map)arrayObject, map);
                }
                continue;
            }
            if (!(object instanceof String)) continue;
            map.put(entry.getKey(), (String)object);
        }
    }

    public static void getNeedMap(String parent, Map<String, Object> jsonObj, Map<String, String> map) throws Exception {
        for (Map.Entry<String, Object> entry : jsonObj.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Map) {
                Map Obj = (Map)object;
                GmUtil.getNeedMap(parent.concat(entry.getKey()), Obj, map);
                continue;
            }
            if (object instanceof List) {
                List jsonArray = (List)object;
                int size = jsonArray.size();
                for (int i = 0; i < size; ++i) {
                    Object arrayObject = jsonArray.get(i);
                    if (arrayObject instanceof String) {
                        map.put(parent.concat((String)arrayObject), (String)arrayObject);
                        continue;
                    }
                    if (!(arrayObject instanceof Map)) continue;
                    GmUtil.getNeedMap(parent.concat(entry.getKey()), (Map)arrayObject, map);
                }
                continue;
            }
            if (!(object instanceof String)) continue;
            map.put(parent.concat(entry.getKey()), (String)object);
        }
    }

    public static Map<String, String> sortMapByKey(Map<String, String> map) throws Exception {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap<String, String> sortMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.compareTo(str2);
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }
}

