/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils;

import com.xwbank.sdk.exception.SDKException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesFileUtil.class);

    public static Properties read(@NotNull String path) throws SDKException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
            Properties properties = PropertiesFileUtil.read(is);
            return properties;
        }
        catch (FileNotFoundException e) {
            throw new SDKException("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        }
    }

    public static Properties read(@NotNull InputStream configStream) throws SDKException {
        try {
            Properties properties = new Properties();
            properties.load(configStream);
            return properties;
        }
        catch (IOException e) {
            throw new SDKException("\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", e);
        }
    }
}

