/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.sm2;

import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.card.SM2Key;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import java.math.BigInteger;

public final class SM2PrivateKey
extends GMTPrivateKey
implements SM2Key {
    private static final long serialVersionUID = -1463950776387286774L;
    private SM2PublicKey sm2PubKey;

    public static SM2PrivateKey getInstance(byte[] encoded) {
        return new SM2PrivateKey(encoded);
    }

    public SM2PrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters, ECPublicKeyParameters ecPublicKeyParameters) {
        super(ecPrivateKeyParameters, ecPublicKeyParameters);
        this.resetSM2PublicKey();
    }

    public SM2PrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters) {
        super(ecPrivateKeyParameters);
        this.resetSM2PublicKey();
    }

    public SM2PrivateKey(byte[] dBytes, byte[] bPubX, byte[] bPubY) {
        super(dBytes, bPubX, bPubY);
        this.resetSM2PublicKey();
    }

    public SM2PrivateKey(byte[] encoding) {
        super(encoding);
        this.resetSM2PublicKey();
    }

    public SM2PrivateKey(BigInteger d, BigInteger iPubX, BigInteger iPubY) {
        super(d, iPubX, iPubY);
        this.resetSM2PublicKey();
    }

    private final void resetSM2PublicKey() {
        GMTPublicKey pubKey = super.getSM2PublicKey();
        this.sm2PubKey = new SM2PublicKey(pubKey.getPubX_Int(), pubKey.getPubY_Int());
    }

    public SM2PublicKey getSM2PublicKey() {
        return this.sm2PubKey;
    }
}

