/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.util;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.ext.MechanismExt;
import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.algorithm.util.SymmetricParams;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.lib.crypto.jni.JNISymAlg;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import cfca.sadk.org.bouncycastle.crypto.StreamCipher;
import cfca.sadk.org.bouncycastle.crypto.engines.AESEngine;
import cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.sadk.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.modes.OFBBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.system.logging.LoggerManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class SymmetricHelper {
    private static final int buffersize = 65536;

    public static boolean fileEncrypt(boolean forJNILib, Mechanism mechanism, byte[] key, InputStream inputStream, OutputStream outputStream) throws PKIException {
        return SymmetricHelper.fileEncrypt(true, forJNILib, mechanism, key, inputStream, outputStream);
    }

    public static boolean fileEncrypt(boolean forJNILib, SymmetricParams mechanismKey, InputStream inputStream, OutputStream outputStream) throws PKIException {
        return SymmetricHelper.fileEncrypt(true, forJNILib, mechanismKey, inputStream, outputStream);
    }

    public static boolean fileDecrypt(boolean forJNILib, Mechanism mechanism, byte[] key, InputStream inputStream, OutputStream outputStream) throws PKIException {
        return SymmetricHelper.fileEncrypt(false, forJNILib, mechanism, key, inputStream, outputStream);
    }

    public static boolean fileDecrypt(boolean forJNILib, SymmetricParams mechanismKey, InputStream inputStream, OutputStream outputStream) throws PKIException {
        return SymmetricHelper.fileEncrypt(false, forJNILib, mechanismKey, inputStream, outputStream);
    }

    public static boolean fileDecrypt(boolean forJNILib, SymmetricParams mechanismKey, ASN1Node nodeFile, OutputStream outputStream) throws Exception {
        if (mechanismKey == null) {
            throw new PKIException("fileDecrypt mechanismKey required not null!");
        }
        if (nodeFile == null) {
            throw new PKIException("fileDecrypt nodeFile required not null!");
        }
        boolean forEncryption = false;
        File file = nodeFile.f;
        if (file == null) {
            throw new PKIException("fileDecrypt nodeFile@file required not null!");
        }
        if (!file.exists()) {
            throw new PKIException("fileDecrypt nodeFile@file not exists: " + file);
        }
        RandomAccessFile raf = null;
        DestroyCipher destroyCipher = null;
        try {
            boolean passed;
            raf = new RandomAccessFile(nodeFile.f, "r");
            raf.seek(nodeFile.valueStartPos);
            StreamFile streamFile = new StreamFile(raf, nodeFile.valueLength);
            if (mechanismKey.nidType == 5) {
                StreamCipher streamCipher = SymmetricHelper.symmetricStreamEncryptInit(false, forJNILib, mechanismKey);
                destroyCipher = SymmetricHelper.convert(streamCipher);
                passed = SymmetricHelper.symmetricStreamEncrypt(streamCipher, streamFile, outputStream);
            } else {
                MBlockCipher blockCipher = SymmetricHelper.symmetricBlockEncryptInit(false, forJNILib, mechanismKey);
                destroyCipher = SymmetricHelper.convert(blockCipher);
                passed = SymmetricHelper.symmetricBlockEncrypt(blockCipher, streamFile, outputStream, true);
            }
            boolean bl = passed;
            return bl;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("fileDecrypt failed", e);
        }
        catch (Throwable e) {
            throw new PKIException("fileDecrypt failed", e);
        }
        finally {
            if (destroyCipher != null) {
                destroyCipher.destroy();
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static boolean fileDecrypt(boolean forJNILib, SymmetricParams mechanismKey, ASN1Node nodeFiles, OutputStream outputStream, RandomAccessFile sourceFile) throws PKIException {
        boolean forDecryptStream;
        if (mechanismKey == null) {
            throw new PKIException("fileDecrypt mechanismKey required not null!");
        }
        if (nodeFiles == null) {
            throw new PKIException("fileDecrypt nodeFiles required not null!");
        }
        if (outputStream == null) {
            throw new PKIException("fileDecrypt outputStream required not null!");
        }
        if (sourceFile == null) {
            throw new PKIException("fileDecrypt sourceFile required not null!");
        }
        boolean forEncryption = false;
        StreamCipher streamCipher = null;
        MBlockCipher blockCipher = null;
        DestroyCipher destroyCipher = null;
        if (mechanismKey.nidType == 5) {
            forDecryptStream = true;
            streamCipher = SymmetricHelper.symmetricStreamEncryptInit(false, forJNILib, mechanismKey);
            destroyCipher = SymmetricHelper.convert(streamCipher);
        } else {
            forDecryptStream = false;
            blockCipher = SymmetricHelper.symmetricBlockEncryptInit(false, forJNILib, mechanismKey);
            destroyCipher = SymmetricHelper.convert(blockCipher);
        }
        try {
            int childLen = nodeFiles.childNodes.size() - 1;
            ASN1Node nodeFile = null;
            StreamFile streamFile = null;
            for (int i = 0; i <= childLen; ++i) {
                nodeFile = (ASN1Node)nodeFiles.childNodes.get(i);
                sourceFile.seek(nodeFile.valueStartPos);
                streamFile = new StreamFile(sourceFile, nodeFile.valueLength);
                if (forDecryptStream) {
                    SymmetricHelper.symmetricStreamEncrypt(streamCipher, streamFile, outputStream);
                    continue;
                }
                SymmetricHelper.symmetricBlockEncrypt(blockCipher, streamFile, outputStream, i == childLen);
            }
        }
        catch (PKIException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PKIException("fileDecrypt failed", e);
        }
        catch (Exception e) {
            throw new PKIException("fileDecrypt failed", e);
        }
        finally {
            if (destroyCipher != null) {
                destroyCipher.destroy();
            }
        }
        return true;
    }

    public static byte[] dataEncrypt(boolean forJNILib, SymmetricParams symmetricParams, byte[] data) throws PKIException {
        return SymmetricHelper.dataEncrypt(true, forJNILib, symmetricParams.mechanism, symmetricParams.symmetricKey, data);
    }

    public static byte[] dataDecrypt(boolean forJNILib, SymmetricParams symmetricParams, byte[] data) throws PKIException {
        return SymmetricHelper.dataEncrypt(false, forJNILib, symmetricParams.mechanism, symmetricParams.symmetricKey, data);
    }

    public static byte[] dataEncrypt(boolean forJNILib, Mechanism mechanism, byte[] key, byte[] data) throws PKIException {
        return SymmetricHelper.dataEncrypt(true, forJNILib, mechanism, key, data);
    }

    public static byte[] dataDecrypt(boolean forJNILib, Mechanism mechanism, byte[] key, byte[] data) throws PKIException {
        return SymmetricHelper.dataEncrypt(false, forJNILib, mechanism, key, data);
    }

    private static byte[] dataEncrypt(boolean forEncryption, boolean forJNILib, Mechanism mechanism, byte[] key, byte[] data) throws PKIException {
        if (mechanism == null) {
            throw new PKIException("fileEncrypt mechanism required not null!");
        }
        if (key == null) {
            throw new PKIException("fileEncrypt key required not null!");
        }
        Object param = mechanism.getParam();
        byte[] iv = null;
        if (param != null && param instanceof CBCParam) {
            iv = ((CBCParam)param).getIv();
        }
        SymmetricParams mechanismKey = new SymmetricParams(mechanism.getMechanismType(), key, iv);
        boolean enabled = forJNILib && data != null && data.length > 0;
        return SymmetricHelper.symmetricEncrypt(forEncryption, enabled, mechanismKey, data);
    }

    private static boolean fileEncrypt(boolean forEncryption, boolean forJNILib, SymmetricParams mechanismKey, InputStream inputStream, OutputStream outputStream) throws PKIException {
        return SymmetricHelper.symmetricEncrypt(forEncryption, forJNILib, mechanismKey, inputStream, outputStream);
    }

    private static boolean fileEncrypt(boolean forEncryption, boolean forJNILib, Mechanism mechanism, byte[] key, InputStream inputStream, OutputStream outputStream) throws PKIException {
        if (mechanism == null) {
            throw new PKIException("fileEncrypt mechanism required not null!");
        }
        if (key == null) {
            throw new PKIException("fileEncrypt key required not null!");
        }
        Object param = mechanism.getParam();
        byte[] iv = null;
        if (param != null && param instanceof CBCParam) {
            iv = ((CBCParam)param).getIv();
        }
        SymmetricParams mechanismKey = new SymmetricParams(mechanism.getMechanismType(), key, iv);
        return SymmetricHelper.fileEncrypt(forEncryption, forJNILib, mechanismKey, inputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean symmetricEncrypt(boolean forEncryption, boolean forJNILib, SymmetricParams mechanismKey, InputStream inputStream, OutputStream outputStream) throws PKIException {
        long streamLength;
        if (mechanismKey == null) {
            throw new PKIException("symmetricEncrypt mechanismKey required not null!");
        }
        if (inputStream == null) {
            throw new PKIException("symmetricEncrypt inputStream required not null!");
        }
        if (outputStream == null) {
            throw new PKIException("symmetricEncrypt outputStream required not null!");
        }
        String mechanismType = mechanismKey.mechanismType;
        if (mechanismType == null) {
            throw new PKIException("symmetricEncrypt mechanismType required not null!");
        }
        try {
            streamLength = inputStream.available();
        }
        catch (IOException e) {
            throw new PKIException("symmetricEncrypt read streamLength failed!", e);
        }
        StreamFile streamFile = new StreamFile(inputStream, streamLength);
        boolean passed = false;
        DestroyCipher destroyCipher = null;
        try {
            if ("RC4".equals(mechanismType)) {
                StreamCipher streamCipher = SymmetricHelper.symmetricStreamEncryptInit(forEncryption, forJNILib, mechanismKey);
                destroyCipher = SymmetricHelper.convert(streamCipher);
                passed = SymmetricHelper.symmetricStreamEncrypt(streamCipher, streamFile, outputStream);
            } else if (mechanismType.indexOf("AES") != -1) {
                MBlockCipher blockCipher = SymmetricHelper.symmetricBlockEncryptInit(forEncryption, false, mechanismKey);
                destroyCipher = SymmetricHelper.convert(blockCipher);
                passed = SymmetricHelper.symmetricBlockEncrypt(blockCipher, streamFile, outputStream, true);
            } else {
                MBlockCipher blockCipher = SymmetricHelper.symmetricBlockEncryptInit(forEncryption, forJNILib, mechanismKey);
                destroyCipher = SymmetricHelper.convert(blockCipher);
                passed = SymmetricHelper.symmetricBlockEncrypt(blockCipher, streamFile, outputStream, true);
            }
        }
        finally {
            if (destroyCipher != null) {
                destroyCipher.destroy();
            }
        }
        return passed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] symmetricEncrypt(boolean forEncryption, boolean forJNILib, SymmetricParams mechanismKey, byte[] blockData) throws PKIException {
        if (mechanismKey == null) {
            throw new PKIException("symmetricEncrypt mechanismKey required not null!");
        }
        if (blockData == null) {
            throw new PKIException("symmetricEncrypt blockData required not null!");
        }
        String mechanismType = mechanismKey.mechanismType;
        if (mechanismType == null) {
            throw new PKIException("symmetricEncrypt mechanismType required not null!");
        }
        byte[] outData = null;
        DestroyCipher destroyCipher = null;
        try {
            if ("RC4".equals(mechanismType)) {
                StreamCipher streamCipher = SymmetricHelper.symmetricStreamEncryptInit(forEncryption, forJNILib, mechanismKey);
                destroyCipher = SymmetricHelper.convert(streamCipher);
                outData = SymmetricHelper.symmetricStreamEncrypt(streamCipher, blockData);
            } else if (mechanismType.indexOf("AES") != -1) {
                MBlockCipher blockCipher = SymmetricHelper.symmetricBlockEncryptInit(forEncryption, false, mechanismKey);
                destroyCipher = SymmetricHelper.convert(blockCipher);
                outData = SymmetricHelper.symmetricBlockEncrypt(blockCipher, blockData);
            } else {
                MBlockCipher blockCipher = SymmetricHelper.symmetricBlockEncryptInit(forEncryption, forJNILib, mechanismKey);
                destroyCipher = SymmetricHelper.convert(blockCipher);
                outData = SymmetricHelper.symmetricBlockEncrypt(blockCipher, blockData);
            }
        }
        finally {
            if (destroyCipher != null) {
                destroyCipher.destroy();
            }
        }
        return outData;
    }

    private static DestroyCipher convert(Object cipher) {
        DestroyCipher destroyCipher = null;
        if (cipher instanceof DestroyCipher) {
            destroyCipher = (DestroyCipher)cipher;
        }
        return destroyCipher;
    }

    private static MBlockCipher symmetricBlockEncryptInit(boolean forEncryption, boolean forJNILib, SymmetricParams mechanismKey) throws PKIException {
        if (mechanismKey == null) {
            throw new PKIException("symmetricBlockEncryptInit mechanismKey required not null!");
        }
        MBlockCipher blockCipher = forJNILib && mechanismKey.nidType != 0 ? SymmetricHelper.symmetricBlockEncryptInit(forEncryption, mechanismKey.nidType, mechanismKey.symmetricKey, mechanismKey.iv) : SymmetricHelper.symmetricBlockEncryptInit(forEncryption, mechanismKey);
        return blockCipher;
    }

    private static MBlockCipher symmetricBlockEncryptInit(boolean forEncryption, SymmetricParams mechanismKey) throws PKIException {
        PaddedBufferedBlockCipher blockCipher;
        String mechanismType;
        block12: {
            if (mechanismKey == null) {
                throw new PKIException("symmetricBlockEncryptInit mechanismKey required not null!");
            }
            mechanismType = mechanismKey.mechanismType;
            if (mechanismType == null) {
                throw new PKIException("symmetricBlockEncryptInit mechanismType required not null!");
            }
            if (mechanismKey.symmetricKey == null) {
                throw new PKIException("symmetricBlockEncryptInit symmetricKey required not null!");
            }
            blockCipher = null;
            try {
                if (mechanismType.equals("DESede/CBC/PKCS7Padding")) {
                    blockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()), new PKCS7Padding());
                    CipherParameters params = mechanismKey.buildCipherParameters(true);
                    blockCipher.init(forEncryption, params);
                    break block12;
                }
                if (mechanismType.equals(MechanismExt.SM4.SM4_CBC)) {
                    blockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
                    CipherParameters params = mechanismKey.buildCipherParameters(true);
                    blockCipher.init(forEncryption, params);
                    break block12;
                }
                if (mechanismType.equals(MechanismExt.SM4.SM4_OFB)) {
                    blockCipher = new PaddedBufferedBlockCipher(new OFBBlockCipher(new SM4Engine(), 128), new PKCS7Padding());
                    CipherParameters params = mechanismKey.buildCipherParameters(true);
                    blockCipher.init(forEncryption, params);
                    break block12;
                }
                if (mechanismType.equals("DESede/ECB/PKCS7Padding")) {
                    blockCipher = new PaddedBufferedBlockCipher(new DESedeEngine(), new PKCS7Padding());
                    CipherParameters params = mechanismKey.buildCipherParameters(false);
                    blockCipher.init(forEncryption, params);
                    break block12;
                }
                if (mechanismType.equals(Mechanism.SM4_ECB)) {
                    blockCipher = new PaddedBufferedBlockCipher(new SM4Engine(), new PKCS7Padding());
                    CipherParameters params = mechanismKey.buildCipherParameters(false);
                    blockCipher.init(forEncryption, params);
                    break block12;
                }
                if (mechanismType.equals("AES/CBC/PKCS7Padding")) {
                    blockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESEngine()), new PKCS7Padding());
                    CipherParameters params = mechanismKey.buildCipherParameters(true);
                    blockCipher.init(forEncryption, params);
                    break block12;
                }
                if (mechanismType.equals("AES/ECB/PKCS7Padding")) {
                    blockCipher = new PaddedBufferedBlockCipher(new AESEngine(), new PKCS7Padding());
                    CipherParameters params = mechanismKey.buildCipherParameters(false);
                    blockCipher.init(forEncryption, params);
                    break block12;
                }
                throw new PKIException("symmetricBlockEncryptInit not support algorithm:" + mechanismType);
            }
            catch (Exception e) {
                throw new PKIException("symmetricBlockEncryptInit init failed for " + mechanismType, e);
            }
        }
        return new MBlockCipher(forEncryption, blockCipher.getBlockSize(), blockCipher, mechanismType);
    }

    private static MBlockCipher symmetricBlockEncryptInit(boolean forEncrypt, int nid_type, byte[] key, byte[] iv) throws PKIException {
        JNISymAlg jni;
        String mechanismType;
        int blockSize;
        switch (nid_type) {
            case 923: {
                if (iv == null || iv.length != 16) {
                    throw new PKIException("symmetricBlockEncryptInit required SM4IV 16-bytes");
                }
                if (key == null || key.length != 16) {
                    throw new PKIException("symmetricBlockEncryptInit required SM4Key 16-bytes");
                }
                blockSize = 16;
                mechanismType = MechanismExt.SM4.SM4_CBC;
                break;
            }
            case 44: {
                if (iv == null || iv.length != 8) {
                    throw new PKIException("symmetricBlockEncryptInit required DESedeIV 8-bytes");
                }
                if (key == null || key.length != 24) {
                    throw new PKIException("symmetricBlockEncryptInit required DESedeKey 24-bytes");
                }
                blockSize = 8;
                mechanismType = "DESede/CBC/PKCS7Padding";
                break;
            }
            case 33: {
                if (key == null || key.length != 24) {
                    throw new PKIException("symmetricBlockEncryptInit required DESedeKey 24-bytes");
                }
                blockSize = 8;
                mechanismType = "DESede/ECB/PKCS7Padding";
                break;
            }
            default: {
                throw new PKIException("symmetricBlockEncryptInit not suportted nid_type=" + nid_type);
            }
        }
        try {
            jni = new JNISymAlg();
            if (forEncrypt) {
                jni.encryptInit(nid_type, key, iv);
            } else {
                jni.decryptInit(nid_type, key, iv);
            }
        }
        catch (Exception e) {
            throw new PKIException("symmetricBlockEncryptInit failed", e);
        }
        catch (Throwable e) {
            throw new PKIException("symmetricBlockEncryptInit failed", e);
        }
        MBlockCipher blockCipher = new MBlockCipher(forEncrypt, blockSize, jni, mechanismType);
        return blockCipher;
    }

    private static boolean symmetricBlockEncrypt(MBlockCipher blockCipher, StreamFile streamFile, OutputStream outputStream, boolean forLastBlock) throws PKIException {
        if (blockCipher == null) {
            throw new PKIException("symmetricBlockEncrypt blockCipher required not null!");
        }
        if (streamFile == null) {
            throw new PKIException("symmetricBlockEncrypt streamFile required not null!");
        }
        if (streamFile.streamLength < 0L) {
            throw new PKIException("symmetricStreamEncrypt streamLength inavailable: " + streamFile.streamLength);
        }
        if (outputStream == null) {
            throw new PKIException("symmetricBlockEncrypt outputStream required not null!");
        }
        String algorithmName = blockCipher.mechanismType == null ? "" : blockCipher.mechanismType;
        int blockSize = blockCipher.blockSize;
        long remainLength = streamFile.streamLength;
        byte[] buffer = new byte[remainLength < 65536L ? (int)remainLength : 65536];
        byte[] outBytes = new byte[buffer.length + blockSize];
        long processTotalLength = 0L;
        int processLength = 0;
        try {
            int readLength = 0;
            while ((readLength = streamFile.read(buffer, 0, buffer.length)) > 0) {
                processLength = blockCipher.processBytes(buffer, 0, readLength, outBytes, 0);
                outputStream.write(outBytes, 0, processLength);
                processTotalLength += (long)processLength;
                if ((remainLength -= (long)readLength) > 0L) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new PKIException(String.format("symmetricBlockEncrypt@%s processBytes failed: remainLength=%s,streamLength=%s", algorithmName, remainLength, streamFile.streamLength), e);
        }
        if (forLastBlock) {
            try {
                processLength = blockCipher.doFinal(outBytes, 0);
                if (processLength > 0) {
                    outputStream.write(outBytes, 0, processLength);
                    processTotalLength += (long)processLength;
                }
            }
            catch (Exception e) {
                throw new PKIException(String.format("symmetricBlockEncrypt@%s doFinal failed: remainLength=%s,streamLength=%s", algorithmName, remainLength, streamFile.streamLength), e);
            }
        }
        if (remainLength != 0L) {
            throw new PKIException(String.format("symmetricBlockEncrypt@%s check failed: remainLength=%s,streamLength=%s", algorithmName, remainLength, streamFile.streamLength));
        }
        if (blockCipher.forEncryption) {
            if (processTotalLength < streamFile.streamLength) {
                throw new PKIException(String.format("symmetricBlockEncrypt@%s encrypt check failed: processTotalLength=%s,streamLength=%s", algorithmName, processTotalLength, streamFile.streamLength));
            }
            if (processTotalLength % (long)blockSize != 0L) {
                throw new PKIException(String.format("symmetricBlockEncrypt@%s encrypt check failed: processTotalLength=%s,blockSize=%s", algorithmName, processTotalLength, streamFile.streamLength));
            }
        }
        return true;
    }

    private static byte[] symmetricBlockEncrypt(MBlockCipher blockCipher, byte[] blockData) throws PKIException {
        if (blockCipher == null) {
            throw new PKIException("symmetricBlockEncrypt blockCipher required not null!");
        }
        if (blockData == null) {
            throw new PKIException("symmetricBlockEncrypt blockData required not null!");
        }
        byte[] outData = blockCipher.forEncryption ? new byte[blockData.length + blockCipher.blockSize] : new byte[blockData.length];
        int length = 0;
        length += blockCipher.processBytes(blockData, 0, blockData.length, outData, 0);
        length += blockCipher.doFinal(outData, length);
        byte[] returnBytes = null;
        if (length < outData.length) {
            returnBytes = new byte[length];
            System.arraycopy(outData, 0, returnBytes, 0, length);
        } else {
            returnBytes = outData;
        }
        return returnBytes;
    }

    private static StreamCipher symmetricStreamEncryptInit(boolean forEncryption, boolean forJNILib, SymmetricParams mechanismKey) throws PKIException {
        if (mechanismKey == null) {
            throw new PKIException("symmetricStreamEncryptInit mechanismKey required not null!");
        }
        StreamCipher streamCipher = null;
        try {
            if (forJNILib) {
                if (mechanismKey.nidType == 0) {
                    throw new PKIException("symmetricStreamEncryptInit do not support nidType=" + mechanismKey.nidType);
                }
                streamCipher = new JNIStreamCipher(mechanismKey.nidType);
            } else {
                streamCipher = new RC4Engine();
            }
            CipherParameters params = mechanismKey.buildCipherParameters(false);
            streamCipher.init(forEncryption, params);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("symmetricStreamEncryptInit failed", e);
        }
        catch (Throwable e) {
            throw new PKIException("symmetricStreamEncryptInit failed", e);
        }
        return streamCipher;
    }

    private static boolean symmetricStreamEncrypt(StreamCipher streamCipher, StreamFile streamFile, OutputStream outputStream) throws PKIException {
        if (streamCipher == null) {
            throw new PKIException("symmetricStreamEncrypt streamCipher required not null!");
        }
        if (streamFile == null) {
            throw new PKIException("symmetricStreamEncrypt streamFile required not null!");
        }
        if (streamFile.streamLength < 0L) {
            throw new PKIException("symmetricStreamEncrypt streamLength inavailable: " + streamFile.streamLength);
        }
        if (outputStream == null) {
            throw new PKIException("symmetricStreamEncrypt outputStream required not null!");
        }
        long remainLength = streamFile.streamLength;
        byte[] buffer = new byte[remainLength < 65536L ? (int)remainLength : 65536];
        byte[] outBytes = new byte[buffer.length];
        try {
            int readLength;
            int length = buffer.length;
            while ((readLength = streamFile.read(buffer, 0, length)) > 0) {
                streamCipher.processBytes(buffer, 0, readLength, outBytes, 0);
                outputStream.write(outBytes, 0, readLength);
                if ((remainLength -= (long)readLength) > 0L) {
                    if (remainLength >= (long)buffer.length) continue;
                    length = (int)remainLength;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new PKIException(String.format("symmetricStreamEncrypt@RC4 failed: remainLength=%s,streamLength=%s", remainLength, streamFile.streamLength), e);
        }
        catch (Throwable e) {
            throw new PKIException(String.format("symmetricStreamEncrypt@RC4 failed: remainLength=%s,streamLength=%s", remainLength, streamFile.streamLength), e);
        }
        if (remainLength != 0L) {
            throw new PKIException(String.format("symmetricStreamEncrypt@RC4 check failed: remainLength=%s,streamLength=%s", remainLength, streamFile.streamLength));
        }
        return true;
    }

    private static byte[] symmetricStreamEncrypt(StreamCipher streamCipher, byte[] blockData) throws PKIException {
        if (streamCipher == null) {
            throw new PKIException("symmetricStreamEncrypt streamCipher required not null!");
        }
        if (blockData == null) {
            throw new PKIException("symmetricStreamEncrypt blockData required not null!");
        }
        byte[] outData = new byte[blockData.length];
        int length = streamCipher.processBytes(blockData, 0, blockData.length, outData, 0);
        if (length != outData.length) {
            throw new PKIException(String.format("symmetricStreamEncrypt required inDataLength(%s)=ouDataLength(%s)", length, blockData.length));
        }
        return outData;
    }

    static final class StreamFile {
        private InputStream stream;
        private RandomAccessFile file;
        final long streamLength;

        StreamFile(InputStream stream, long streamLength) {
            this.stream = stream;
            this.streamLength = streamLength;
        }

        StreamFile(RandomAccessFile file, long streamLength) {
            this.file = file;
            this.streamLength = streamLength;
        }

        int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.stream != null) {
                return this.stream.read(buffer, offset, length);
            }
            if (this.file != null) {
                return this.file.read(buffer, offset, length);
            }
            throw new IOException("missing stream&file");
        }
    }

    static interface DestroyCipher {
        public void destroy();
    }

    static final class JNIStreamCipher
    implements StreamCipher,
    DestroyCipher {
        final int nid_type;
        final JNISymAlg jni;
        final String algorithmName;
        boolean forEncryption;
        boolean requiredDestroy;

        JNIStreamCipher(int nid_type) throws PKIException {
            switch (nid_type) {
                case 5: {
                    this.algorithmName = "RC4";
                    break;
                }
                default: {
                    throw new PKIException("JNIStreamCipher not support nid_type=" + nid_type);
                }
            }
            this.jni = new JNISymAlg();
            this.nid_type = nid_type;
            this.requiredDestroy = false;
        }

        public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
            if (params == null) {
                throw new IllegalArgumentException("JNIStreamCipher missing params");
            }
            if (!(params instanceof KeyParameter)) {
                throw new IllegalArgumentException("JNIStreamCipher required KeyParameter");
            }
            KeyParameter key = (KeyParameter)params;
            byte[] kBytes = key.getKey();
            if (kBytes == null || kBytes.length != 16) {
                throw new IllegalArgumentException("JNIStreamCipher required KeyParameter with 16-bytes");
            }
            try {
                this.requiredDestroy = true;
                if (forEncryption) {
                    this.jni.encryptInit(this.nid_type, kBytes, null);
                } else {
                    this.jni.decryptInit(this.nid_type, kBytes, null);
                }
            }
            catch (Exception e) {
                throw new SecurityException("JNIStreamCipher encryptInit/decryptInit failed", e);
            }
            catch (Throwable e) {
                throw new SecurityException("JNIStreamCipher encryptInit/decryptInit failed", e);
            }
            this.forEncryption = forEncryption;
        }

        public void destroy() {
            if (this.requiredDestroy) {
                try {
                    LoggerManager.systemLogger.info("JNISymAlg destroy...");
                    byte[] outData = new byte[64];
                    this.requiredDestroy = false;
                    if (this.forEncryption) {
                        this.jni.encryptFinal(outData, 0);
                    } else {
                        this.jni.decryptFinal(outData, 0);
                    }
                    LoggerManager.systemLogger.info("JNISymAlg destroy okay.");
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.warn("JNISymAlg destroy failed", (Throwable)e);
                }
                catch (Throwable e) {
                    LoggerManager.exceptionLogger.warn("JNISymAlg destroy failed", e);
                }
            }
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public byte returnByte(byte in) {
            throw new UnsupportedOperationException("JNIStreamCipher returnByte");
        }

        public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
            int returnLength;
            try {
                returnLength = this.forEncryption ? this.jni.encryptProcess(in, inOff, len, out, outOff) : this.jni.decryptProcess(in, inOff, len, out, outOff);
            }
            catch (Exception e) {
                throw new SecurityException("JNIStreamCipher encryptProcess/decryptProcess failed", e);
            }
            catch (Throwable e) {
                throw new SecurityException("JNIStreamCipher encryptProcess/decryptProcess failed", e);
            }
            return returnLength;
        }

        public void reset() {
            throw new UnsupportedOperationException("JNIStreamCipher reset");
        }
    }

    static final class MBlockCipher
    implements DestroyCipher {
        JNISymAlg jni;
        PaddedBufferedBlockCipher blockCipher;
        final boolean forEncryption;
        final int blockSize;
        final String mechanismType;
        private boolean requiredDestroy = true;

        MBlockCipher(boolean forEncryption, int blockSize, JNISymAlg jni, String mechanismType) throws PKIException {
            this.forEncryption = forEncryption;
            this.blockSize = blockSize;
            this.jni = jni;
            this.blockCipher = null;
            this.mechanismType = mechanismType;
            this.requiredDestroy = jni != null;
        }

        MBlockCipher(boolean forEncryption, int blockSize, PaddedBufferedBlockCipher blockCipher, String mechanismType) throws PKIException {
            this.forEncryption = forEncryption;
            this.blockSize = blockSize;
            this.jni = null;
            this.blockCipher = blockCipher;
            this.mechanismType = mechanismType;
            this.requiredDestroy = false;
        }

        public int processBytes(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws PKIException {
            int returnLength;
            if (this.jni != null) {
                try {
                    if (this.forEncryption) {
                        returnLength = this.jni.encryptProcess(in, inOff, inLen, out, outOff);
                    }
                    returnLength = this.jni.decryptProcess(in, inOff, inLen, out, outOff);
                }
                catch (Exception e) {
                    throw new PKIException("MBlockCipher encryptProcess/decryptProcess failed", e);
                }
                catch (Throwable e) {
                    throw new PKIException("MBlockCipher encryptProcess/decryptProcess failed", e);
                }
            } else if (this.blockCipher != null) {
                try {
                    returnLength = this.blockCipher.processBytes(in, inOff, inLen, out, outOff);
                }
                catch (Exception e) {
                    throw new PKIException("MBlockCipher processBytes failed", e);
                }
            } else {
                throw new PKIException("MBlockCipher required blockCipher/jni");
            }
            return returnLength;
        }

        int doFinal(byte[] out, int outOff) throws PKIException {
            int returnLength;
            if (this.jni != null) {
                try {
                    this.requiredDestroy = false;
                    if (this.forEncryption) {
                        returnLength = this.jni.encryptFinal(out, outOff);
                    }
                    returnLength = this.jni.decryptFinal(out, outOff);
                }
                catch (Exception e) {
                    throw new PKIException("MBlockCipher encryptFinal/decryptFinal failed", e);
                }
                catch (Throwable e) {
                    throw new PKIException("MBlockCipher encryptFinal/decryptFinal failed", e);
                }
            } else if (this.blockCipher != null) {
                try {
                    returnLength = this.blockCipher.doFinal(out, outOff);
                }
                catch (Exception e) {
                    throw new PKIException("MBlockCipher doFinal failed", e);
                }
            } else {
                throw new PKIException("MBlockCipher required blockCipher/jni");
            }
            return returnLength;
        }

        public void destroy() {
            if (this.jni != null && this.requiredDestroy) {
                try {
                    LoggerManager.systemLogger.info("JNISymAlg destroy...");
                    byte[] outData = new byte[64];
                    this.requiredDestroy = false;
                    if (this.forEncryption) {
                        this.jni.encryptFinal(outData, 0);
                    } else {
                        this.jni.decryptFinal(outData, 0);
                    }
                    LoggerManager.systemLogger.info("JNISymAlg destroy okay.");
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.warn("JNISymAlg destroy failed", (Throwable)e);
                }
                catch (Throwable e) {
                    LoggerManager.exceptionLogger.warn("JNISymAlg destroy failed", e);
                }
            }
        }
    }
}

