/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.ext.MechanismExt;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.algorithm.util.SymmetricParams;
import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

final class FileEncryptedInputStream
extends ASN1Primitive {
    private static final Set<String> SUPPORT_SET = new HashSet<String>(8);
    private File sourceFile;
    private byte[] key;
    private Mechanism contentEncryptionAlg;
    private final long encodedFileLength;
    private final boolean useJNIFlag;

    static final FileEncryptedInputStream getInstance(Object obj) {
        if (obj != null && obj instanceof FileEncryptedInputStream) {
            return (FileEncryptedInputStream)obj;
        }
        return null;
    }

    FileEncryptedInputStream(boolean useJNIFlag, File sourceFile, byte[] key, Mechanism contentEncryptionAlg) throws PKIException {
        if (sourceFile == null || sourceFile.length() == 0L) {
            throw new PKIException("MEncryptedInputStream@sourceFile is empty!");
        }
        if (key == null || key.length == 0) {
            throw new PKIException("MEncryptedInputStream@key is empty!");
        }
        if (contentEncryptionAlg == null) {
            throw new PKIException("MEncryptedInputStream@contentEncryptionAlg is empty!");
        }
        if (contentEncryptionAlg.getMechanismType() == null) {
            throw new PKIException("MEncryptedInputStream@mechanismType is empty!");
        }
        int blockSize = SymmetricParams.getBlockSize(contentEncryptionAlg.getMechanismType());
        long encodedFileLength = sourceFile.length();
        if (blockSize != 0) {
            long padd = encodedFileLength % (long)blockSize;
            encodedFileLength += (long)blockSize - padd;
        }
        if (!SUPPORT_SET.contains(contentEncryptionAlg.getMechanismType())) {
            throw new PKIException("MEncryptedInputStream@can not support this algorithm:" + contentEncryptionAlg);
        }
        this.sourceFile = sourceFile;
        this.key = key;
        this.contentEncryptionAlg = contentEncryptionAlg;
        this.encodedFileLength = encodedFileLength;
        this.useJNIFlag = useJNIFlag;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isConstructed() {
        return false;
    }

    public int encodedLength() throws IOException {
        return 1 + StreamUtil.calculateBodyLength((int)this.encodedFileLength) + (int)this.encodedFileLength;
    }

    public void encode(ASN1OutputStream out) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.sourceFile);
            out.write(4);
            out.writeLength((int)this.encodedFileLength);
            SymmetricHelper.fileEncrypt(this.useJNIFlag, this.contentEncryptionAlg, this.key, (InputStream)inputStream, (OutputStream)out);
        }
        catch (PKIException e) {
            throw new SecurityException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SecurityException("MEncryptedInputStream@Envelope failed: " + e.getMessage(), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean asn1Equals(ASN1Primitive o) {
        throw new UnsupportedOperationException("MEncryptedInputStream@asn1Equals");
    }

    static {
        SUPPORT_SET.add("RC4");
        SUPPORT_SET.add("DESede/CBC/PKCS7Padding");
        SUPPORT_SET.add("DESede/ECB/PKCS7Padding");
        SUPPORT_SET.add(MechanismExt.SM4.SM4_CBC);
        SUPPORT_SET.add(MechanismExt.SM4.SM4_ECB);
        SUPPORT_SET.add(MechanismExt.SM4.SM4_OFB);
        SUPPORT_SET.add("AES/CBC/PKCS7Padding");
        SUPPORT_SET.add("AES/ECB/PKCS7Padding");
    }
}

