/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope;

import cfca.sadk.envelope.FileEncryptedContentInfo;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.ASN1TaggedObject;
import cfca.sadk.org.bouncycastle.asn1.BERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.cms.OriginatorInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import java.util.Enumeration;

final class FileEnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private OriginatorInfo originatorInfo;
    private ASN1Set recipientInfos;
    private FileEncryptedContentInfo encryptedContentInfo;
    private ASN1Set unprotectedAttrs;

    FileEnvelopedData(OriginatorInfo originatorInfo, ASN1Set recipientInfos, FileEncryptedContentInfo encryptedContentInfo, ASN1Set unprotectedAttrs) {
        this.version = new ASN1Integer(FileEnvelopedData.calculateVersion(originatorInfo, recipientInfos, unprotectedAttrs));
        this.originatorInfo = originatorInfo;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
        this.unprotectedAttrs = unprotectedAttrs;
    }

    FileEnvelopedData(ASN1Sequence seq) {
        int index = 0;
        this.version = (ASN1Integer)seq.getObjectAt(index++);
        ASN1Encodable tmp = seq.getObjectAt(index++);
        if (tmp instanceof ASN1TaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)tmp, false);
            tmp = seq.getObjectAt(index++);
        }
        this.recipientInfos = ASN1Set.getInstance(tmp);
        this.encryptedContentInfo = FileEncryptedContentInfo.getInstance(seq.getObjectAt(index++));
        if (seq.size() > index) {
            this.unprotectedAttrs = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(index), false);
        }
    }

    static final FileEnvelopedData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return FileEnvelopedData.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    static final FileEnvelopedData getInstance(Object obj) {
        if (obj instanceof FileEnvelopedData) {
            return (FileEnvelopedData)obj;
        }
        if (obj != null) {
            return new FileEnvelopedData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public FileEncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Set getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        if (this.originatorInfo != null) {
            v.add(new DERTaggedObject(false, 0, this.originatorInfo));
        }
        v.add(this.recipientInfos);
        v.add(this.encryptedContentInfo);
        if (this.unprotectedAttrs != null) {
            v.add(new DERTaggedObject(false, 1, this.unprotectedAttrs));
        }
        return new BERSequence(v);
    }

    public static int calculateVersion(OriginatorInfo originatorInfo, ASN1Set recipientInfos, ASN1Set unprotectedAttrs) {
        int version;
        if (originatorInfo != null || unprotectedAttrs != null) {
            version = 2;
        } else {
            version = 0;
            Enumeration e = recipientInfos.getObjects();
            while (e.hasMoreElements()) {
                RecipientInfo ri = RecipientInfo.getInstance(e.nextElement());
                if (ri.getVersion().getValue().intValue() == version) continue;
                version = 2;
                break;
            }
        }
        return version;
    }
}

