/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.bridge.impl.rsa.RSACardKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;

public final class RSACardLoggings {
    private RSACardLoggings() {
    }

    static final String buildPrivateKeyOperationRSAFailedMessage(RSACardKey rsaKey, byte[] dataInput) {
        StringBuilder builder = new StringBuilder(128);
        if (rsaKey != null && rsaKey.isInternalKey()) {
            builder.append("RSACard cardPrivateKeyOperationRSA");
        } else {
            builder.append("RSACard cardPrivateKeyOperationRSA");
        }
        builder.append(" failure: ");
        if (rsaKey != null) {
            builder.append(",keyIndex: ").append(rsaKey.getKeyIndex());
            builder.append(",params: ").append(rsaKey.dumpPublicKey());
        }
        builder.append(",dataInput: ").append(DataHelper.dump4KPartData(dataInput));
        return builder.toString();
    }

    static final String buildPublicKeyOperationRSAFailedMessage(RSACardKey rsaKey, byte[] dataInput) {
        StringBuilder builder = new StringBuilder(128);
        if (rsaKey != null && rsaKey.isInternalKey()) {
            builder.append("RSACard cardPublicKeyOperationRSA");
        } else {
            builder.append("RSACard cardPublicKeyOperationRSA");
        }
        builder.append(" failure: ");
        if (rsaKey != null) {
            builder.append(",keyIndex: ").append(rsaKey.getKeyIndex());
            builder.append(",params: ").append(rsaKey.dumpPublicKey());
        }
        builder.append(",dataInput: ").append(DataHelper.dump4KPartData(dataInput));
        return builder.toString();
    }

    static final StringBuilder buildKeyPairCheckFailed(StringBuilder builder, KeyPair keyPair) {
        if (keyPair != null) {
            RSAPublicKey pubKey = (RSAPublicKey)keyPair.getPublic();
            builder.append("\nPrivateKey: ").append(keyPair.getPrivate());
            builder.append("\nPublicKey: ").append(pubKey);
            builder.append("\nmodule: ").append(pubKey.getModulus().toString(16));
        } else {
            builder.append("\nkeyPair=null");
        }
        return builder;
    }

    static final void warningGenerateKeyPairFailed(boolean isExport, int bitLength, int keyIndex, int keyUsage, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("RSACard generateKeyPair failure: ");
            builder.append("isExport=").append(isExport);
            builder.append(", bitLength=").append(bitLength);
            builder.append(", keyIndex=").append(isExport);
            builder.append(" , keyUsage=").append(keyUsage);
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static final void warningSignByHashFailed(RSACardKey privateKey, byte[] hashWithAlgorithm, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("RSACard signByHash failure: ");
            builder.append(" privateKey=").append(privateKey);
            builder.append(", hashWithAlgorithm=").append(hashWithAlgorithm == null ? "" : DataHelper.dump4KPartData(hashWithAlgorithm));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static final void warningVerifyByHashFailed(RSACardKey publicKey, byte[] hashWithAlgorithm, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("RSACard verifyByHash failure: ");
            builder.append(" publicKey=").append(publicKey);
            builder.append(", hashWithAlgorithm=").append(DataHelper.dump4KPartData(hashWithAlgorithm));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static final void warningEncryptFailed(RSACardKey publicKey, byte[] sourceData, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("RSACard [PublicKeyOperation]encrypt failure: ");
            builder.append(" publicKey=").append(publicKey);
            builder.append(", sourceData=").append(sourceData == null ? "" : DataHelper.dump4KPartData(sourceData));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static final void warninDecryptFailed(RSACardKey privateKey, byte[] encryptData, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("RSACard [PrivateKeyOperation]decrypt failure: ");
            builder.append(" privateKey=").append(privateKey);
            builder.append(", encryptData=").append(encryptData == null ? "" : DataHelper.dump4KPartData(encryptData));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }
}

