/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.envelope.SessionEncryptMode;
import cfca.sadk.lib.crypto.DeviceInfo;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.StreamEncryptChecker;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.hard.encryptor.AbsEncryptor;
import cfca.sadk.lib.crypto.hard.format.SM2Format;
import cfca.sadk.lib.crypto.hard.generator.AbsGenerator;
import cfca.sadk.lib.crypto.hard.signer.AbsSigner;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.HashUtil;
import cfca.sadk.util.KeyUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;

public class HardLib
implements Session {
    private String providerName;
    private Provider provider;
    private final boolean asn1SignOutputFormat;
    private final int sm2EncryptFormatProviderType;

    public HardLib(String providerPath) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HardLib constructor startup with providerPath=" + providerPath);
        }
        if (providerPath == null || providerPath.trim().length() == 0) {
            providerPath = "com.sansec.jce.provider.SwxaProvider";
        }
        LoggerManager.systemLogger.info("HardLib constructor providerPath=" + providerPath);
        try {
            this.provider = (Provider)Class.forName(providerPath).newInstance();
            this.providerName = this.provider.getName();
        }
        catch (Exception e) {
            LoggerManager.systemLogger.info("HardLib constructor warnning in newInstance", (Throwable)e);
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + this.providerName, e);
        }
        Mechanism mechanism = null;
        KeyPair keypair = null;
        try {
            mechanism = new Mechanism("SM2");
            keypair = this.generateKeyPair(mechanism, 256);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("HardLib constructor warnning in GenerateKeyPair", (Throwable)e);
        }
        this.asn1SignOutputFormat = SM2Format.signingFormat(this.provider, keypair);
        this.sm2EncryptFormatProviderType = SM2Format.encryptFormat(this.provider, keypair);
        LoggerManager.systemLogger.info("sm2SigningASN1Format=" + this.asn1SignOutputFormat);
        LoggerManager.systemLogger.info("sm2EncryptFormatProviderType=" + this.sm2EncryptFormatProviderType);
    }

    public final Key generateKey(Mechanism mechanism) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("GenerateKey>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("GenerateKey failure with missing mechanism");
            }
            String type = mechanism.getMechanismType();
            SecureRandom random = new SecureRandom();
            SecretKeySpec key = null;
            if ("SM4".equals(type)) {
                byte[] keyData = new byte[16];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else if ("DESede".equals(type)) {
                byte[] keyData = new byte[24];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else if ("RC4".equals(type)) {
                byte[] keyData = new byte[16];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else {
                throw new PKIException("GenerateKey failure with invalid keyType=" + mechanism.getMechanismType());
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKey<<<<<<Finished: key=" + SADKDebugger.dump(key));
            }
            return key;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", (Throwable)e);
            throw new PKIException("GenerateKey failure with exception", e);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", (Throwable)e);
            throw new PKIException("GenerateKey failure with exception", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", e);
            throw new PKIException("GenerateKey failure with throwable", e);
        }
    }

    public final Key generateKey(Mechanism mechanism, byte[] keyData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("generateKeyPair>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n keyData: ");
            buffer.append(SADKDebugger.dump(keyData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("GenerateKey failure with missing mechanism");
            }
            Key key = KeyUtil.generateKey(mechanism, keyData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKey<<<<<<Finished: key=" + SADKDebugger.dump(key));
            }
            return key;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", (Throwable)e);
            throw new PKIException("GenerateKey failure with exception", e);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", (Throwable)e);
            throw new PKIException("GenerateKey failure with exception", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("GenerateKey<<<<<<Failure", e);
            throw new PKIException("GenerateKey failure with throwable", e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign message >>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            AbsSigner signer = AbsSigner.createSigner(this.provider, mechanism, this.asn1SignOutputFormat);
            signer.initSign(priKey);
            signer.update(sourceData);
            byte[] signData = signer.sign();
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("sign message <<<<<<Finished: signData=" + SADKDebugger.dump(signData));
            }
            return signData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("sign message <<<<<<Failure", (Throwable)e);
            throw new PKIException("sign message failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("sign message <<<<<<Failure", e);
            throw new PKIException("sign message failure", e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        InputStream sourceData = null;
        try {
            AbsSigner signer = AbsSigner.createSigner(this.provider, mechanism, this.asn1SignOutputFormat);
            signer.initSign(priKey);
            signer.update(sourceStream);
            byte[] signData = signer.sign();
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("sign stream <<<<<<Finished: signData=" + SADKDebugger.dump(signData));
            }
            byte[] byArray = signData;
            return byArray;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("sign stream <<<<<<Failure", (Throwable)e);
            throw new PKIException("sign stream failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("sign stream <<<<<<Failure", e);
            throw new PKIException("sign stream failure", e);
        }
        finally {
            if (sourceData != null) {
                try {
                    sourceData.close();
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("sign stream failure", (Throwable)e);
                    throw new PKIException("sign stream failure", e);
                }
            }
        }
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            AbsSigner signer = AbsSigner.createSigner(this.provider, mechanism, this.asn1SignOutputFormat);
            signer.initVerify(pubKey);
            signer.update(sourceData);
            boolean verifyResult = signer.verify(signData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("verify message <<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("verify message <<<<<<Failure", (Throwable)e);
            throw new PKIException("verify message failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verify message <<<<<<Failure", e);
            throw new PKIException("verify message failure", e);
        }
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        InputStream sourceData = null;
        try {
            AbsSigner signer = AbsSigner.createSigner(this.provider, mechanism, this.asn1SignOutputFormat);
            signer.initVerify(pubKey);
            signer.update(sourceStream);
            boolean verifyResult = signer.verify(signData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("verify stream <<<<<<Finished: verifyResult=" + verifyResult);
            }
            boolean bl = verifyResult;
            return bl;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("verify stream <<<<<<Failure", (Throwable)e);
            throw new PKIException("verify stream failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verify stream <<<<<<Failure", e);
            throw new PKIException("verify stream failure", e);
        }
        finally {
            if (sourceData != null) {
                try {
                    sourceData.close();
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("verify stream failure", (Throwable)e);
                    throw new PKIException("verify stream failure", e);
                }
            }
        }
    }

    public final byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encrypt message >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            AbsEncryptor encryptor = AbsEncryptor.createHelper(this.provider, mechanism, this.sm2EncryptFormatProviderType);
            byte[] encryptData = null;
            encryptData = encryptor != null ? encryptor.encrypt(mechanism, key, sourceData) : BCSoftLib.INSTANCE().encrypt(mechanism, key, sourceData);
            return encryptData;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("encrypt message <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n key=").append(SADKDebugger.dump(key));
            builder.append("\n sourceData=").append(SADKDebugger.dump(sourceData));
            LoggerManager.exceptionLogger.error(builder.toString(), (Throwable)e);
            throw new PKIException("encrypt message failure:", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("encrypt message <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n key=").append(SADKDebugger.dump(key));
            builder.append("\n sourceData=").append(SADKDebugger.dump(sourceData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("encrypt message failure:", e);
        }
    }

    public final byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decrypt message >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            AbsEncryptor encryptor = AbsEncryptor.createHelper(this.provider, mechanism, this.sm2EncryptFormatProviderType);
            byte[] decryptData = null;
            decryptData = encryptor != null ? encryptor.decrypt(mechanism, key, encryptData) : BCSoftLib.INSTANCE().decrypt(mechanism, key, encryptData);
            return decryptData;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("decrypt message <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n key=").append(SADKDebugger.dump(key));
            builder.append("\n encryptData=").append(SADKDebugger.dump(encryptData));
            LoggerManager.exceptionLogger.error(builder.toString(), (Throwable)e);
            throw new PKIException("decrypt message failure:", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("decrypt message <<<<<<Failure");
            builder.append("\n mechanism=").append(mechanism.getMechanismType());
            builder.append("\n key=").append(SADKDebugger.dump(key));
            builder.append("\n encryptData=").append(SADKDebugger.dump(encryptData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("decrypt message failure:", e);
        }
    }

    public final KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("GenerateKeyPair >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n keyLength: " + keyLength);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            AbsGenerator generator = AbsGenerator.createGenerator(this.provider, mechanism);
            KeyPair keypair = generator.generateKeyPair(mechanism, keyLength);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKeyPair <<<<<<Finished: decryptData=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("GenerateKeyPair failure", (Throwable)e);
            throw new PKIException("GenerateKeyPair failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("GenerateKeyPair failure", e);
            throw new PKIException("GenerateKeyPair failure", e);
        }
    }

    public final byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] hashValue) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("signByHash >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        String mType = mechanism.getMechanismType();
        try {
            HashUtil.checkHashLength(mechanism, hashValue);
            AbsSigner signer = AbsSigner.createSigner(this.provider, mechanism, this.asn1SignOutputFormat);
            byte[] signData = signer.signByHash(priKey, hashValue);
            LoggerManager.debugLogger.debug("signByHash<<<<<<Finished");
            return signData;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("signByHash <<<<<<Failure");
            builder.append("\n mechanism=").append(mType);
            builder.append("\n priKey=").append(SADKDebugger.dump(priKey));
            builder.append("\n hashValue=").append(SADKDebugger.dump(hashValue));
            LoggerManager.exceptionLogger.error(builder.toString(), (Throwable)e);
            throw new PKIException("signByHash failure:", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("signByHash <<<<<<Failure");
            builder.append("\n mechanism=").append(mType);
            builder.append("\n priKey=").append(SADKDebugger.dump(priKey));
            builder.append("\n hashValue=").append(SADKDebugger.dump(hashValue));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("signByHash failure:", e);
        }
    }

    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] hashValue, byte[] signData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("verifyByHash >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        String mType = mechanism.getMechanismType();
        try {
            HashUtil.checkHashLength(mechanism, hashValue);
            AbsSigner signer = AbsSigner.createSigner(this.provider, mechanism, this.asn1SignOutputFormat);
            boolean verifyResult = signer.verifyByHash(pubKey, hashValue, signData);
            LoggerManager.debugLogger.debug("verifyByHash<<<<<<Finished: " + verifyResult);
            return verifyResult;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("verifyByHash <<<<<<Failure");
            builder.append("\n mechanism=").append(mType);
            builder.append("\n pubKey=").append(SADKDebugger.dump(pubKey));
            builder.append("\n hashValue=").append(SADKDebugger.dump(hashValue));
            builder.append("\n signData=").append(SADKDebugger.dump(signData));
            LoggerManager.exceptionLogger.error(builder.toString(), (Throwable)e);
            throw new PKIException("verifyByHash failure:", e);
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append("verifyByHash <<<<<<Failure");
            builder.append("\n mechanism=").append(mType);
            builder.append("\n pubKey=").append(SADKDebugger.dump(pubKey));
            builder.append("\n hashValue=").append(SADKDebugger.dump(hashValue));
            builder.append("\n signData=").append(SADKDebugger.dump(signData));
            LoggerManager.exceptionLogger.error(builder.toString(), e);
            throw new PKIException("verifyByHash failure:", e);
        }
    }

    public final void encrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws PKIException {
        try {
            LoggerManager.debugLogger.debug("encrypt stream<<<<<<running...");
            StreamEncryptChecker.checkAllowedKeyType(key);
            AbsEncryptor encryptor = AbsEncryptor.createHelper(this.provider, mechanism, this.sm2EncryptFormatProviderType);
            if (encryptor != null) {
                encryptor.encrypt(mechanism, key, in, out);
            } else {
                BCSoftLib.INSTANCE().encrypt(mechanism, key, in, out);
            }
            LoggerManager.debugLogger.debug("encrypt stream<<<<<<Finished");
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encrypt stream failure", (Throwable)e);
            throw new PKIException("encrypt stream failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encrypt stream failure", e);
            throw new PKIException("encrypt stream failure", e);
        }
    }

    public final void decrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws PKIException {
        try {
            LoggerManager.debugLogger.debug("decrypt stream<<<<<<running...");
            StreamEncryptChecker.checkAllowedKeyType(key);
            AbsEncryptor encryptor = AbsEncryptor.createHelper(this.provider, mechanism, this.sm2EncryptFormatProviderType);
            if (encryptor != null) {
                encryptor.decrypt(mechanism, key, in, out);
            } else {
                BCSoftLib.INSTANCE().decrypt(mechanism, key, in, out);
            }
            LoggerManager.debugLogger.debug("decrypt stream<<<<<<Finished");
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encrypt stream failure", (Throwable)e);
            throw new PKIException("decrypt stream failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encrypt stream failure", e);
            throw new PKIException("decrypt stream failure", e);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getProviderName() {
        return this.providerName;
    }

    public PublicKey exportEncPublicKey() throws PKIException {
        throw new PKIException("exportEncPublicKey failure: not support HardLib!");
    }

    public boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws PKIException {
        throw new PKIException("importSM2KeyPair failure: not support HardLib!");
    }

    public final String getDeviceName() {
        return "JHARD_LIB";
    }

    public final int getDeviceType() {
        return 2;
    }

    public boolean checkIdleTest() throws PKIException {
        return true;
    }

    public final boolean useJniNativeOperation() throws PKIException {
        return CompatibleConfig.SM2EnvelopeEncryptMode == SessionEncryptMode.JHARDSESSION.sessionType;
    }

    public DeviceInfo[] getDeviceInfos() throws PKIException {
        return null;
    }
}

