/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.P7BParser;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.entity.JKSEntity;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.system.Environments;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CertUtil {
    /*
     * Exception decompiling
     */
    public static byte[] getCertExtensionData(X509Cert x509Cert, String oid) throws PKIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Extensions getCertExtensionsData(X509Cert x509Cert) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertExtensionsData>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (x509Cert == null) {
                throw new PKIException("getCertExtensionsData Failure: x509Cert should not be null");
            }
            return x509Cert.getExtensionsData();
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertExtensionsData<<<<<<Failure", (Throwable)e);
            throw new SecurityException(e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertExtensionsData<<<<<<Failure", e);
            throw new SecurityException("getCertExtensionsData Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert getCertFromSM2(String sm2FilePath) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromSM2>>>>>>Running");
            buffer.append("\n sm2FilePath: ");
            buffer.append(SADKDebugger.dump(sm2FilePath));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encoding;
            if (sm2FilePath == null) {
                throw new PKIException("getCertFromSM2 Failure: SM2File sm2FilePath should not be null");
            }
            try {
                encoding = FileHelper.read(sm2FilePath);
            }
            catch (Exception e) {
                throw new PKIException("getCertFromSM2 Failure: SM2File read failure", e);
            }
            X509Cert x509Cert = CertUtil.getCertFromSM2(encoding);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getCertFromSM2<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertFromSM2<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertFromSM2<<<<<<Failure", e);
            throw new PKIException("getCertFromSM2 Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert getCertFromSM2(InputStream sm2FileInputStream) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromSM2>>>>>>Running");
            buffer.append("\n sm2FileInputStream: ");
            buffer.append(SADKDebugger.dump(sm2FileInputStream));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encoding;
            int dLength;
            if (sm2FileInputStream == null) {
                throw new PKIException("getCertFromSM2 Failure: SM2File sm2FileInputStream should not be null");
            }
            try {
                dLength = sm2FileInputStream.available();
            }
            catch (IOException e) {
                throw new PKIException("getCertFromSM2 Failure: SM2File sm2FileInputStream invalid", e);
            }
            if (dLength > 1024000) {
                throw new PKIException("getCertFromSM2 Failure: SM2File sm2FileInputStream too large");
            }
            try {
                encoding = new byte[dLength];
                sm2FileInputStream.read(encoding);
            }
            catch (Exception e) {
                throw new PKIException("getCertFromSM2 Failure: SM2File sm2FileInputStream read failure", e);
            }
            X509Cert x509Cert = CertUtil.getCertFromSM2(encoding);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getCertFromSM2<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertFromSM2<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertFromSM2<<<<<<Failure", e);
            throw new PKIException("getCertFromSM2 Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert getCertFromSM2(byte[] sm2FileData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromSM2>>>>>>Running");
            buffer.append("\n sm2FileData: ");
            buffer.append(SADKDebugger.dump(sm2FileData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (sm2FileData == null) {
                throw new PKIException("getCertFromSM2 Failure: SM2File sm2FileData should not be null");
            }
            PKCS12_SM2 P12 = new PKCS12_SM2(sm2FileData);
            X509Cert x509Cert = P12.getPublicCert()[0];
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getCertFromSM2<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertFromSM2<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertFromSM2<<<<<<Failure", e);
            throw new PKIException("getCertFromSM2 Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert getCertFromPFX(String pfxFilePath, String pfxFilePwd) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromPFX>>>>>>Running");
            buffer.append("\n pfxFilePath: ");
            buffer.append(SADKDebugger.dump(pfxFilePath));
            buffer.append("\n pfxFilePwd: hidden");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encoding;
            if (pfxFilePath == null) {
                throw new PKIException("getCertFromPFX Failure: PFXFile pfxFilePath should not be null");
            }
            try {
                encoding = FileHelper.read(pfxFilePath);
            }
            catch (Exception e) {
                throw new PKIException("getCertFromPFX Failure: PFXFile read failure", e);
            }
            X509Cert x509Cert = CertUtil.getCertFromPFX(encoding, pfxFilePwd);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getCertFromPFX<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertFromPFX<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertFromPFX<<<<<<Failure", e);
            throw new PKIException("getCertFromPFX Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert getCertFromPFX(InputStream pfxFileInputStream, String pfxFilePwd) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromPFX>>>>>>Running");
            buffer.append("\n pfxFileInputStream: ");
            buffer.append(SADKDebugger.dump(pfxFileInputStream));
            buffer.append("\n pfxFilePwd: hidden");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encoding;
            int dLength;
            if (pfxFileInputStream == null) {
                throw new PKIException("getCertFromPFX Failure: PFXFile pfxFileInputStream should not be null");
            }
            try {
                dLength = pfxFileInputStream.available();
            }
            catch (IOException e) {
                throw new PKIException("getCertFromPFX Failure: PFXFile pfxFileInputStream invalid", e);
            }
            if (dLength > 1024000) {
                throw new PKIException("getCertFromPFX Failure: PFXFile pfxFileInputStream too large");
            }
            try {
                encoding = new byte[dLength];
                pfxFileInputStream.read(encoding);
            }
            catch (Exception e) {
                throw new PKIException("getCertFromPFX Failure: PFXFile pfxFileInputStream read failure", e);
            }
            X509Cert x509Cert = CertUtil.getCertFromPFX(encoding, pfxFilePwd);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getCertFromPFX<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertFromPFX<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertFromPFX<<<<<<Failure", e);
            throw new PKIException("getCertFromPFX Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert getCertFromPFX(byte[] pfxFileData, String pfxFilePwd) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromPFX>>>>>>Running");
            buffer.append("\n pfxFileData: ");
            buffer.append(SADKDebugger.dump(pfxFileData));
            buffer.append("\n pfxFilePwd: hidden");
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (pfxFileData == null) {
                throw new PKIException("getCertFromPFX Failure: PFXFile pfxFileData should not be null");
            }
            if (pfxFilePwd == null) {
                throw new PKIException("getCertFromPFX Failure: PFXFile pfxFilePwd should not be null");
            }
            PKCS12 P12 = new PKCS12(pfxFileData);
            try {
                P12.decrypt(pfxFilePwd.toCharArray());
            }
            catch (Exception e) {
                throw new PKIException("getCertFromPFX Failure: PFXFile pfxFileData decrypting failure", e);
            }
            X509Cert x509Cert = P12.getCerts()[0];
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getCertFromPFX<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertFromPFX<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertFromPFX<<<<<<Failure", e);
            throw new PKIException("getCertFromPFX Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert getCertFromJKS(String jksFilePath, String jksFilePwd, String alias) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromJKS>>>>>>Running");
            buffer.append("\n jksFilePath: ");
            buffer.append(SADKDebugger.dump(jksFilePath));
            buffer.append("\n jksFilePwd: hidden");
            buffer.append("\n alias: ");
            buffer.append(SADKDebugger.dump(alias));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (jksFilePath == null) {
                throw new PKIException("getCertFromJKS Failure: JKSFile jksFilePath should not be null");
            }
            if (jksFilePwd == null) {
                throw new PKIException("getCertFromJKS Failure: JKSFile jksFilePwd should not be null");
            }
            if (alias == null) {
                throw new PKIException("getCertFromJKS Failure: JKSFile alias should not be null");
            }
            try {
                JKSEntity jks = new JKSEntity(jksFilePath, jksFilePwd);
                X509Cert x509Cert = jks.getCert(alias);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("getCertFromJKS<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
                }
                return x509Cert;
            }
            catch (Exception e) {
                throw new PKIException("getCertFromJKS Failure: JKSFile parsed failure", e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertFromJKS<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertFromJKS<<<<<<Failure", e);
            throw new PKIException("getCertFromJKS Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert getCertFromJKS(InputStream jksInputStream, String jksFilePwd, String alias) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getCertFromJKS>>>>>>Running");
            buffer.append("\n jksInputStream: ");
            buffer.append(SADKDebugger.dump(jksInputStream));
            buffer.append("\n jksFilePwd: hidden");
            buffer.append("\n alias: ");
            buffer.append(SADKDebugger.dump(alias));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (jksInputStream == null) {
                throw new PKIException("getCertFromJKS Failure: JKSFile jksInputStream should not be null");
            }
            if (jksFilePwd == null) {
                throw new PKIException("getCertFromJKS Failure: JKSFile jksFilePwd should not be null");
            }
            if (alias == null) {
                throw new PKIException("getCertFromJKS Failure: JKSFile alias should not be null");
            }
            try {
                JKSEntity jks = new JKSEntity(jksInputStream, jksFilePwd);
                X509Cert x509Cert = jks.getCert(alias);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("getCertFromJKS<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
                }
                return x509Cert;
            }
            catch (Exception e) {
                throw new PKIException("getCertFromJKS Failure: JKSFile parsed failure", e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCertFromJKS<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCertFromJKS<<<<<<Failure", e);
            throw new PKIException("getCertFromJKS Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert[] parseP7B(String p7bFilePath) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("parseP7B>>>>>>Running");
            buffer.append("\n p7bFilePath: ");
            buffer.append(SADKDebugger.dump(p7bFilePath));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encoding;
            if (p7bFilePath == null) {
                throw new PKIException("parseP7B Failure: P7BFile p7bFilePath should not be null");
            }
            try {
                encoding = FileHelper.read(p7bFilePath);
            }
            catch (Exception e) {
                throw new PKIException("parseP7B Failure: P7BFile read failure", e);
            }
            X509Cert[] x509Certs = CertUtil.parseP7B(encoding);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("parseP7B<<<<<<Finished: X509Certs=" + SADKDebugger.dump(x509Certs));
            }
            return x509Certs;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("parseP7B<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("parseP7B<<<<<<Failure", e);
            throw new PKIException("parseP7B Failure: " + e.getMessage(), e);
        }
    }

    public static X509Cert[] parseP7B(byte[] p7bData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("parseP7B>>>>>>Running");
            buffer.append("\n p7bData: ");
            buffer.append(SADKDebugger.dump(p7bData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (p7bData == null) {
                throw new PKIException("parseP7B Failure: P7BFile p7bData should not be null");
            }
            try {
                X509Cert[] x509Certs = P7BParser.parseP7B(p7bData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("parseP7B<<<<<<Finished: X509Certs=" + SADKDebugger.dump(x509Certs));
                }
                return x509Certs;
            }
            catch (Exception e) {
                throw new PKIException("parseP7B Failure: P7BFile parsed failure", e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("parseP7B<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("parseP7B<<<<<<Failure", e);
            throw new PKIException("parseP7B Failure: " + e.getMessage(), e);
        }
    }

    public static void generateP7BFile(X509Cert[] certs, String outP7bFilePath) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateP7BFile>>>>>>Running");
            buffer.append("\n certs: ");
            buffer.append(SADKDebugger.dump(certs));
            buffer.append("\n outP7bFilePath: ");
            buffer.append(SADKDebugger.dump(outP7bFilePath));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (certs == null) {
                throw new PKIException("generateP7BFile Failure: P7BFile certs should not be null");
            }
            if (outP7bFilePath == null) {
                throw new PKIException("generateP7BFile Failure: P7BFile outP7bFilePath should not be null");
            }
            try {
                P7BParser.generateP7BFile(certs, outP7bFilePath);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("generateP7BFile<<<<<<Finished: outP7bFilePath=" + SADKDebugger.dump(outP7bFilePath));
                }
            }
            catch (Exception e) {
                throw new PKIException("generateP7BFile Failure: P7BFile Generated failure", e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateP7BFile<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateP7BFile<<<<<<Failure", e);
            throw new PKIException("generateP7BFile Failure: " + e.getMessage(), e);
        }
    }

    public static void generateP7BFile(X509Cert[] certs, OutputStream out) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateP7BFile>>>>>>Running");
            buffer.append("\n certs: ");
            buffer.append(SADKDebugger.dump(certs));
            buffer.append("\n out: ");
            buffer.append(SADKDebugger.dump(out));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (certs == null) {
                throw new PKIException("generateP7BFile Failure: P7BFile certs should not be null");
            }
            if (out == null) {
                throw new PKIException("generateP7BFile Failure: P7BFile OutputStream should not be null");
            }
            try {
                P7BParser.generateP7BFile(certs, out);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("generateP7BFile<<<<<<Finished: outP7bStream=" + SADKDebugger.dump(out));
                }
            }
            catch (Exception e) {
                throw new PKIException("generateP7BFile Failure: P7BFile Generated failure", e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateP7BFile<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateP7BFile<<<<<<Failure", e);
            throw new PKIException("generateP7BFile Failure: " + e.getMessage(), e);
        }
    }

    public static byte[] generateP7BData(X509Cert[] certs) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateP7BData>>>>>>Running");
            buffer.append("\n certs: ");
            buffer.append(SADKDebugger.dump(certs));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            if (certs == null) {
                throw new PKIException("generateP7BData Failure: P7BFile certs should not be null");
            }
            try {
                byte[] base64P7BData = P7BParser.generateP7BData(certs);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("generateP7BData<<<<<<Finished: base64P7BData=" + SADKDebugger.dump(base64P7BData));
                }
                return base64P7BData;
            }
            catch (Exception e) {
                throw new PKIException("generateP7BData Failure: P7BFile Generated failure", e);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("generateP7BData<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("generateP7BData<<<<<<Failure", e);
            throw new PKIException("generateP7BData Failure: " + e.getMessage(), e);
        }
    }

    public static boolean isSM2Cert(X509Cert x509Cert) {
        return x509Cert != null && x509Cert.isSM2Cert();
    }

    public static boolean isCACert(X509Cert x509Cert) throws PKIException {
        return x509Cert != null && x509Cert.isCACert();
    }

    static {
        Environments.environments();
    }
}

