/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsigninterface;

import cn.com.infosec.netsign.der.util.PKCS7SignedData;
import cn.com.infosec.netsign.der.util.PKCS7SignedDataGenerater;
import cn.com.infosec.netsigninterface.OIDUtil;
import cn.com.infosec.netsigninterface.SignatureUtil;
import com.infosec.NetSignServer;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class PKCS7SignedDataUtil {
    public static byte[] generatePKCS7SignedData(byte[] plainText, PrivateKey prik, String digestAlg, byte[] id, X509Certificate signCert, X509Certificate[] certChain, boolean isDetached) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, CertificateEncodingException, IOException {
        byte[] signed = SignatureUtil.sign(plainText, prik, digestAlg, id, signCert);
        String digestAlgOid = OIDUtil.getDigestAlgOID(digestAlg);
        String encryptAlgOid = OIDUtil.getEncryptAlgOID(prik);
        PKCS7SignedData p7sdp = new PKCS7SignedData();
        if (!isDetached) {
            p7sdp.setContent(plainText);
        }
        p7sdp.setDigestAlgOid(digestAlgOid);
        p7sdp.setDigestEncryptionAlgOid(encryptAlgOid);
        p7sdp.setSignCertIssuerSubjectDer(signCert.getIssuerX500Principal().getEncoded());
        p7sdp.setSignCertSN(signCert.getSerialNumber());
        p7sdp.setSignature(signed);
        if (NetSignServer.withCertChain) {
            p7sdp.setCerts((Certificate[])certChain);
        } else {
            p7sdp.setCerts(new Certificate[]{signCert});
        }
        PKCS7SignedDataGenerater p7sdg = new PKCS7SignedDataGenerater(p7sdp);
        return p7sdg.generatePKCS7SignedData();
    }
}

