/*
 * Decompiled with CFR 0.152.
 */
package com.infosec;

import cn.com.infosec.jce.provider.InfosecProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;

public class EncCerts {
    private String _certDirPath;

    static {
        Security.addProvider((Provider)new InfosecProvider());
    }

    public EncCerts(String certDirPath) {
        System.out.println("Enc certs path :" + certDirPath);
        if (certDirPath == null || certDirPath.equals("")) {
            throw new InvalidParameterException("\u6ca1\u6709\u4e0b\u8f7dCRL\u7684\u5b58\u653e\u76ee\u5f55");
        }
        File file = new File(certDirPath);
        if (!file.isDirectory()) {
            throw new InvalidParameterException("\u4fe1\u4efb\u8bc1\u4e66\u8def\u5f84\u9519\u8bef");
        }
        if (!file.canRead()) {
            throw new InvalidParameterException("\u4e0d\u80fd\u8bfb\u53d6\u6307\u5b9a\u7684CRL\u7684\u76ee\u5f55");
        }
        this._certDirPath = certDirPath;
    }

    public Hashtable getCerts() {
        Hashtable<String, X509Certificate> ht = new Hashtable<String, X509Certificate>();
        File f = new File(this._certDirPath);
        File[] certFiles = f.listFiles();
        int i = 0;
        while (i < certFiles.length) {
            block7: {
                X509Certificate cert = null;
                String dn = null;
                try {
                    FileInputStream fis = new FileInputStream(certFiles[i]);
                    CertificateFactory certFact = CertificateFactory.getInstance("X.509", "INFOSEC");
                    cert = (X509Certificate)certFact.generateCertificate(fis);
                    fis.close();
                    if (cert != null) {
                        dn = cert.getSubjectDN().getName();
                    }
                    System.out.println("EncCert : " + dn);
                }
                catch (NoSuchProviderException ex) {
                    break block7;
                }
                catch (IOException ex) {
                    break block7;
                }
                catch (CertificateException ex) {
                    break block7;
                }
                if (cert != null && dn != null) {
                    ht.put(dn, cert);
                }
            }
            ++i;
        }
        return ht;
    }
}

