/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.pkcs.pkcs12;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.BERSequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.pkcs.pkcs7.ContentInfo;

public class AuthenticatedSafe
implements DEREncodable {
    private ContentInfo[] info;

    public static AuthenticatedSafe getInstance(Object o) {
        if (o == null || o instanceof AuthenticatedSafe) {
            return (AuthenticatedSafe)o;
        }
        if (o instanceof ASN1Sequence) {
            return new AuthenticatedSafe((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory " + o.getClass().getName());
    }

    public AuthenticatedSafe(ASN1Sequence seq) {
        this.info = new ContentInfo[seq.size()];
        int i = 0;
        while (i != this.info.length) {
            this.info[i] = ContentInfo.getInstance(seq.getObjectAt(i));
            ++i;
        }
    }

    public AuthenticatedSafe(ContentInfo[] info) {
        this.info = info;
    }

    public ContentInfo[] getContentInfo() {
        return this.info;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i != this.info.length) {
            v.add(this.info[i]);
            ++i;
        }
        return new BERSequence(v);
    }
}

