/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.pkcs.pkcs7;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;

public class DigestedData
implements DEREncodable,
PKCSObjectIdentifiers {
    private DERInteger version;
    private AlgorithmIdentifier digestAlgorithm;
    private ContentInfo contentInfo;
    private ASN1OctetString digest;

    public static DigestedData getInstance(Object o) {
        if (o == null || o instanceof DigestedData) {
            return (DigestedData)o;
        }
        if (o instanceof ASN1Sequence) {
            return new DigestedData((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory:" + o.getClass().getName());
    }

    public DigestedData(DERInteger _version, AlgorithmIdentifier _digestAlgorithm, ContentInfo _contentInfo, ASN1OctetString _digest) {
        this.version = _version;
        this.digestAlgorithm = _digestAlgorithm;
        this.contentInfo = _contentInfo;
        this.digest = _digest;
    }

    public DigestedData(ASN1Sequence seq) {
        this.version = (DERInteger)seq.getObjectAt(0);
        this.digestAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.contentInfo = ContentInfo.getInstance(seq.getObjectAt(2));
        this.digest = ASN1OctetString.getInstance(seq.getObjectAt(3));
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public ASN1OctetString getDigest() {
        return this.digest;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.digestAlgorithm);
        v.add(this.contentInfo);
        v.add(this.digest);
        return new DERSequence(v);
    }
}

