/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERGeneralizedTime;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERTaggedObject;
import com.cfca.util.pki.asn1.DERUTCTime;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.Time;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;

public class TBSCertList
implements DEREncodable {
    ASN1Sequence seq;
    DERInteger version;
    AlgorithmIdentifier signature;
    X509Name issuer;
    Time thisUpdate;
    Time nextUpdate;
    CRLEntry[] revokedCertificates;
    X509Extensions crlExtensions;

    public static TBSCertList getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSCertList.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSCertList getInstance(Object obj) {
        if (obj instanceof TBSCertList) {
            return (TBSCertList)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new TBSCertList((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public TBSCertList(ASN1Sequence seq) {
        int seqPos = 0;
        this.seq = seq;
        this.version = seq.getObjectAt(seqPos) instanceof DERInteger ? (DERInteger)seq.getObjectAt(seqPos++) : new DERInteger(0);
        this.signature = AlgorithmIdentifier.getInstance(seq.getObjectAt(seqPos++));
        this.issuer = X509Name.getInstance(seq.getObjectAt(seqPos++));
        this.thisUpdate = Time.getInstance(seq.getObjectAt(seqPos++));
        if (seqPos < seq.size() && (seq.getObjectAt(seqPos) instanceof DERUTCTime || seq.getObjectAt(seqPos) instanceof DERGeneralizedTime || seq.getObjectAt(seqPos) instanceof Time)) {
            this.nextUpdate = Time.getInstance(seq.getObjectAt(seqPos++));
        }
        if (seqPos < seq.size() && !(seq.getObjectAt(seqPos) instanceof DERTaggedObject)) {
            ASN1Sequence certs = (ASN1Sequence)seq.getObjectAt(seqPos++);
            this.revokedCertificates = new CRLEntry[certs.size()];
            int i = 0;
            while (i < this.revokedCertificates.length) {
                this.revokedCertificates[i] = new CRLEntry((ASN1Sequence)certs.getObjectAt(i));
                ++i;
            }
        }
        if (seqPos < seq.size() && seq.getObjectAt(seqPos) instanceof DERTaggedObject) {
            this.crlExtensions = X509Extensions.getInstance(seq.getObjectAt(seqPos++));
        }
    }

    public int getVersion() {
        return this.version.getValue().intValue() + 1;
    }

    public DERInteger getVersionNumber() {
        return this.version;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public Time getThisUpdate() {
        return this.thisUpdate;
    }

    public Time getNextUpdate() {
        return this.nextUpdate;
    }

    public CRLEntry[] getRevokedCertificates() {
        return this.revokedCertificates;
    }

    public X509Extensions getExtensions() {
        return this.crlExtensions;
    }

    public DERObject getDERObject() {
        return this.seq;
    }

    public class CRLEntry
    implements DEREncodable {
        ASN1Sequence seq;
        DERInteger userCertificate;
        Time revocationDate;
        X509Extensions crlEntryExtensions;

        public CRLEntry(ASN1Sequence seq) {
            this.seq = seq;
            this.userCertificate = (DERInteger)seq.getObjectAt(0);
            this.revocationDate = Time.getInstance(seq.getObjectAt(1));
            if (seq.size() == 3) {
                this.crlEntryExtensions = X509Extensions.getInstance(seq.getObjectAt(2));
            }
        }

        public DERInteger getUserCertificate() {
            return this.userCertificate;
        }

        public Time getRevocationDate() {
            return this.revocationDate;
        }

        public X509Extensions getExtensions() {
            return this.crlEntryExtensions;
        }

        public DERObject getDERObject() {
            return this.seq;
        }
    }
}

