/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.cms.CMSEnvelopedGenerator;
import com.cfca.util.pki.cms.CMSException;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;

class CMSEnvelopedHelper {
    static final CMSEnvelopedHelper INSTANCE = new CMSEnvelopedHelper();
    private static final Map KEYSIZES = new HashMap();
    private static final Map BASE_CIPHER_NAMES = new HashMap();
    private static final Map CIPHER_ALG_NAMES = new HashMap();

    static {
        KEYSIZES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, new Integer(192));
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_EBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_ECB, "DES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_CBC, "DES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.RC4, "RC4");
        BASE_CIPHER_NAMES.put("2.16.840.1.101.3.4.1.2", "AES");
        BASE_CIPHER_NAMES.put("2.16.840.1.101.3.4.1.1", "AES");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_EBC, "DESEDE/ECB/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.DES_ECB, "DES/ECB/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.DES_CBC, "DES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put("2.16.840.1.101.3.4.1.2", "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put("2.16.840.1.101.3.4.1.1", "AES/ECB/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.RC4, "RC4");
    }

    CMSEnvelopedHelper() {
    }

    private String getAsymmetricEncryptionAlgName(String encryptionAlgOID) {
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(encryptionAlgOID)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return encryptionAlgOID;
    }

    Cipher createAsymmetricCipher(String encryptionOid, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        try {
            return this.createCipher(encryptionOid, provider);
        }
        catch (NoSuchAlgorithmException e) {
            return this.createCipher(this.getAsymmetricEncryptionAlgName(encryptionOid), provider);
        }
    }

    KeyGenerator createSymmetricKeyGenerator(String encryptionOID, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            return this.createKeyGenerator(encryptionOID, provider);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                String algName = (String)BASE_CIPHER_NAMES.get(encryptionOID);
                if (algName != null) {
                    return this.createKeyGenerator(algName, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (provider != null) {
                return this.createSymmetricKeyGenerator(encryptionOID, null);
            }
            throw e;
        }
    }

    AlgorithmParameters createAlgorithmParameters(String encryptionOID, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            return this.createAlgorithmParams(encryptionOID, provider);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                String algName = (String)BASE_CIPHER_NAMES.get(encryptionOID);
                if (algName != null) {
                    return this.createAlgorithmParams(algName, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            throw e;
        }
    }

    String getRFC3211WrapperName(String oid) {
        String alg = (String)BASE_CIPHER_NAMES.get(oid);
        if (alg == null) {
            throw new IllegalArgumentException("no name for " + oid);
        }
        return String.valueOf(alg) + "RFC3211Wrap";
    }

    int getKeySize(String oid) {
        Integer keySize = (Integer)KEYSIZES.get(oid);
        if (keySize == null) {
            throw new IllegalArgumentException("no keysize for " + oid);
        }
        return keySize;
    }

    private Cipher createCipher(String algName, String provider) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider != null) {
            return Cipher.getInstance(algName, provider);
        }
        return Cipher.getInstance(algName);
    }

    private AlgorithmParameters createAlgorithmParams(String algName, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (provider != null) {
            return AlgorithmParameters.getInstance(algName, provider);
        }
        return AlgorithmParameters.getInstance(algName);
    }

    private KeyGenerator createKeyGenerator(String algName, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (provider != null) {
            return KeyGenerator.getInstance(algName, provider);
        }
        return KeyGenerator.getInstance(algName);
    }

    Cipher getSymmetricCipher(String encryptionOID, String provider) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return this.createCipher(encryptionOID, provider);
        }
        catch (NoSuchAlgorithmException e) {
            String alternate = (String)CIPHER_ALG_NAMES.get(encryptionOID);
            try {
                return this.createCipher(alternate, provider);
            }
            catch (NoSuchAlgorithmException ex) {
                if (provider != null) {
                    return this.getSymmetricCipher(encryptionOID, null);
                }
                throw e;
            }
        }
    }

    AlgorithmParameters getEncryptionAlgorithmParameters(String encOID, byte[] encParams, String provider) throws CMSException, NoSuchProviderException {
        if (encParams == null) {
            return null;
        }
        try {
            AlgorithmParameters params = this.createAlgorithmParameters(encOID, provider);
            params.init(encParams, "ASN.1");
            return params;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find parameters for algorithm", e);
        }
        catch (IOException e) {
            throw new CMSException("can't find parse parameters", e);
        }
    }

    String getSymmetricCipherName(String oid) {
        String algName = (String)BASE_CIPHER_NAMES.get(oid);
        if (algName != null) {
            return algName;
        }
        return oid;
    }
}

