/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.ASN1Object;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.cms.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.cms.KeyAgreeRecipientInfo;
import com.cfca.util.pki.asn1.cms.OriginatorPublicKey;
import com.cfca.util.pki.asn1.cms.RecipientEncryptedKey;
import com.cfca.util.pki.asn1.pkcs.pkcs8.PrivateKeyInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.RecipientId;
import com.cfca.util.pki.cms.RecipientInformation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo _info;
    private AlgorithmIdentifier _encAlg;
    private ASN1OctetString _encryptedKey;

    public KeyAgreeRecipientInformation(KeyAgreeRecipientInfo info, AlgorithmIdentifier encAlg, InputStream data) {
        super(encAlg, AlgorithmIdentifier.getInstance(info.getKeyEncryptionAlgorithm()), data);
        this._info = info;
        this._encAlg = encAlg;
        try {
            ASN1Sequence s = this._info.getRecipientEncryptedKeys();
            RecipientEncryptedKey id = RecipientEncryptedKey.getInstance(s.getObjectAt(0));
            IssuerAndSerialNumber iAnds = id.getIdentifier().getIssuerAndSerialNumber();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(iAnds.getName());
            this._rid = new RecipientId();
            this._rid.setIssuer(bOut.toByteArray());
            this._rid.setSerialNumber(iAnds.getSerialNumber().getValue());
            this._encryptedKey = id.getEncryptedKey();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid rid in KeyAgreeRecipientInformation");
        }
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        try {
            OriginatorPublicKey origK = this._info.getOriginator().getOriginatorKey();
            PrivateKeyInfo privInfo = PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(key.getEncoded()));
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(privInfo.getAlgorithmId(), origK.getPublicKey().getBytes());
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
            KeyFactory fact = KeyFactory.getInstance(this._keyEncAlg.getObjectId().getId(), prov);
            KeyAgreement agreement = KeyAgreement.getInstance(this._keyEncAlg.getObjectId().getId(), prov);
            agreement.init(key);
            agreement.doPhase(fact.generatePublic(pubSpec), true);
            String wrapAlg = DERObjectIdentifier.getInstance(ASN1Sequence.getInstance(this._keyEncAlg.getParameters()).getObjectAt(0)).getId();
            SecretKey wKey = agreement.generateSecret(wrapAlg);
            Cipher keyCipher = Cipher.getInstance(wrapAlg, prov);
            keyCipher.init(4, wKey);
            AlgorithmIdentifier aid = this._encAlg;
            String alg = aid.getObjectId().getId();
            byte[] encryptedKey = this._encryptedKey.getOctets();
            Key sKey = keyCipher.unwrap(encryptedKey, alg, 3);
            return this.getContentFromSessionKey(sKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CMSException("originator key spec invalid.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (Exception e) {
            throw new CMSException("originator key invalid.", e);
        }
    }
}

