/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.crl;

import com.cfca.util.pki.PKIConstant;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.TBSCertList;
import com.cfca.util.pki.asn1.x509.Time;
import com.cfca.util.pki.asn1.x509.V2TBSCertListGenerator;
import com.cfca.util.pki.asn1.x509.X509Extension;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.JKeyPair;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.crl.X509CRL;
import com.cfca.util.pki.extension.AuthorityKeyIdentifierExt;
import com.cfca.util.pki.extension.CRLNumberExt;
import com.cfca.util.pki.extension.Extension;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class X509CRLGenerator {
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private Mechanism mechanism = null;
    private V2TBSCertListGenerator tbsCRLGen = new V2TBSCertListGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private TBSCertList tbsCRL = null;
    private DERBitString signature = null;
    private String issuerName = null;
    private Date thisUpdate = null;
    private Hashtable extensionSet = new Hashtable();

    public void addRevokeCert(String certSerialNumber, Date revokeTime) {
        BigInteger bigIntSN = new BigInteger(certSerialNumber, 16);
        this.tbsCRLGen.addCRLEntry(new DERInteger(bigIntSN), new Time(revokeTime), 0);
    }

    public void addRevokeCert(String certSerialNumber, Date revokeTime, int reason) {
        BigInteger bigIntSN = new BigInteger(certSerialNumber, 16);
        this.tbsCRLGen.addCRLEntry(new DERInteger(bigIntSN), new Time(revokeTime), reason);
    }

    public void addRevokeCert(BigInteger certSerialNumber, Date revokeTime) {
        this.tbsCRLGen.addCRLEntry(new DERInteger(certSerialNumber), new Time(revokeTime), 0);
    }

    public void addRevokeCert(BigInteger certSerialNumber, Date revokeTime, int reason) {
        this.tbsCRLGen.addCRLEntry(new DERInteger(certSerialNumber), new Time(revokeTime), reason);
    }

    public void setIssuer(String issuerName) {
        this.issuerName = issuerName;
        X509Name x509Issuer = new X509Name(issuerName);
        this.tbsCRLGen.setIssuer(x509Issuer);
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
        this.tbsCRLGen.setThisUpdate(new Time(thisUpdate));
    }

    public void setNextUpdate(Date nextUpdate) {
        this.tbsCRLGen.setNextUpdate(new Time(nextUpdate));
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException("850404", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (signatureAlgorithm.equals("MD2withRSAEncryption")) {
            this.mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (signatureAlgorithm.equals("MD5withRSAEncryption")) {
            this.mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (signatureAlgorithm.equals("SHA1withRSAEncryption")) {
            this.mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (signatureAlgorithm.endsWith("SHA1withECDSA")) {
            this.mechanism = new Mechanism("SHA1withECDSA");
        } else if (signatureAlgorithm.endsWith("SHA1withDSA")) {
            this.mechanism = new Mechanism("SHA1withDSA");
        } else {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5: " + signatureAlgorithm);
        }
        DERObjectIdentifier oid = (DERObjectIdentifier)PKIConstant.sigAlgName2OID.get(signatureAlgorithm);
        this.sigAlg = new AlgorithmIdentifier(oid);
        this.tbsCRLGen.setSignature(this.sigAlg);
    }

    public void setExtension(Vector extensions) throws PKIException {
        int size = extensions.size();
        int i = 0;
        while (i < size) {
            Extension extension = (Extension)extensions.get(i);
            DERObjectIdentifier derOID = new DERObjectIdentifier(extension.getOID());
            boolean critical = extension.getCritical();
            byte[] extensionValue = null;
            try {
                extensionValue = extension.encode();
            }
            catch (PKIException ex) {
                throw new PKIException("850410", "\u6269\u5c55\u57df\u7f16\u7801\u9519\u8bef", ex);
            }
            DEROctetString derOctet = new DEROctetString(extensionValue);
            this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), (ASN1OctetString)derOctet));
            ++i;
        }
    }

    public void addExtension(Extension extension) throws PKIException {
        DERObjectIdentifier derOID = new DERObjectIdentifier(extension.getOID());
        boolean critical = extension.getCritical();
        byte[] extensionValue = null;
        try {
            extensionValue = extension.encode();
        }
        catch (PKIException ex) {
            throw new PKIException("850410", "\u6269\u5c55\u57df\u7f16\u7801\u9519\u8bef", ex);
        }
        DEROctetString derOctet = new DEROctetString(extensionValue);
        this.extensionSet.put(derOID, new X509Extension(extension.getCritical(), (ASN1OctetString)derOctet));
    }

    public byte[] generateCRL(JKey priKey, Session session) throws PKIException {
        if (this.issuerName == null || this.issuerName.equals("")) {
            throw new PKIException("850403", "\u9881\u53d1\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.thisUpdate == null) {
            throw new PKIException("850413", "CRL\u672c\u6b21\u66f4\u65b0\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sigAlg == null) {
            throw new PKIException("850404", "\u7b7e\u540d\u7b97\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.generateSignature(priKey, session);
        return this.constructCRL();
    }

    private void generateSignature(JKey priKey, Session session) throws PKIException {
        if (this.extensionSet.size() > 0) {
            this.tbsCRLGen.setExtensions(new X509Extensions(this.extensionSet));
        }
        this.tbsCRL = this.tbsCRLGen.generateTBSCertList();
        byte[] bTBSCRL = null;
        try {
            bTBSCRL = Parser.writeDERObj2Bytes(this.tbsCRL.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("850415", "TBS CRL\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        byte[] signatureData = null;
        try {
            signatureData = session.sign(this.mechanism, priKey, bTBSCRL);
        }
        catch (Exception ex) {
            throw new PKIException("05", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        this.signature = new DERBitString(signatureData);
    }

    private byte[] constructCRL() throws PKIException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsCRL);
        v.add(this.sigAlg);
        v.add(this.signature);
        DERSequence derSeq = new DERSequence(v);
        byte[] certData = null;
        try {
            certData = Parser.writeDERObj2Bytes(derSeq.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("850414", "CRL\u8f6cbyte[]\u5931\u8d25", ex);
        }
        return certData;
    }

    public static void main(String[] args) {
        X509CRLGenerator x509CRLGenerator = new X509CRLGenerator();
        try {
            JCrypto jCrypto = JCrypto.getInstance();
            jCrypto.initialize("JSOFT_LIB", null);
            Mechanism mechanism = new Mechanism("RSA");
            Session session = jCrypto.openSession("JSOFT_LIB");
            JKeyPair keyPair = session.generateKeyPair(mechanism, 1024);
            JKey priKey = keyPair.getPrivateKey();
            JKey PubKey = keyPair.getPublicKey();
            x509CRLGenerator.setIssuer("CN=IDA,C=CN");
            x509CRLGenerator.setThisUpdate(new Date());
            x509CRLGenerator.setNextUpdate(new Date(System.currentTimeMillis() + 0x6DDD00L));
            x509CRLGenerator.setSignatureAlg("SHA1withRSAEncryption");
            x509CRLGenerator.addRevokeCert("a11111111111111", new Date(), 2);
            x509CRLGenerator.addRevokeCert("b22222222222222", new Date());
            CRLNumberExt crlnumberExt = new CRLNumberExt();
            System.out.println(crlnumberExt.getOID());
            crlnumberExt.setCritical(true);
            crlnumberExt.SetCRLNumber(new BigInteger("500"));
            x509CRLGenerator.addExtension(crlnumberExt);
            AuthorityKeyIdentifierExt aki = new AuthorityKeyIdentifierExt(PubKey);
            aki.setAuthorityCertIssuer("cn=jfdk,o=jit,c=cn");
            aki.setAuthorityCertSerialNumber(new BigInteger("8888"));
            x509CRLGenerator.addExtension(aki);
            byte[] actualReturn = x509CRLGenerator.generateCRL(priKey, session);
            FileOutputStream fos = new FileOutputStream("D:/TESTCRL.crl");
            fos.write(actualReturn);
            fos.flush();
            fos.close();
            X509CRL crl = new X509CRL(actualReturn);
            boolean verify = crl.verify(keyPair.getPublicKey(), session);
            String issuer = crl.getIssuer();
            String signatureAlgName = crl.getSignatureAlgName();
            Date thisUpdate = crl.getThisUpdate();
            boolean isRevoke = crl.isRevoke("a11111111111111");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

