/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Object;
import com.cfca.util.pki.asn1.ASN1SequenceExt;
import com.cfca.util.pki.asn1.DERBMPString;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DERBoolean;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DEREncodableVector;
import com.cfca.util.pki.asn1.DERGeneralizedTime;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNumericString;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.DERT61String;
import com.cfca.util.pki.asn1.DERUTCTime;
import com.cfca.util.pki.asn1.DERUTF8String;
import com.cfca.util.pki.asn1.DERUniversalString;
import com.cfca.util.pki.asn1.DERVisibleString;
import com.cfca.util.pki.asn1.x509.SubjectDirectoryAttributes;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class SubjectDirectoryAttributesExt
extends AbstractStandardExtension {
    public static final short NONE = -1;
    public static final short UTCTIME = 0;
    public static final short GENERALIZEDTIME = 1;
    public static final short BITSTRING = 2;
    public static final short PRINTABLESTRING = 3;
    public static final short BMPSTRING = 4;
    public static final short IA5STRING = 5;
    public static final short NUMERICSTRING = 6;
    public static final short OCTETSTRING = 7;
    public static final short T61STRING = 8;
    public static final short UNIVERSALSTRING = 9;
    public static final short UTF8STRING = 10;
    public static final short VISIBLESTRING = 11;
    private HashMap AttrMap = new HashMap();
    private boolean isHaveAttribute = false;

    public SubjectDirectoryAttributesExt() {
        this.OID = X509Extensions.SubjectDirectoryAttributes.getId();
        this.critical = false;
    }

    public void addSubjectDirectoryAttribute(String OID, String value, short type) throws PKIException {
        if (!this.isHaveAttribute) {
            this.isHaveAttribute = true;
        }
        this.addAttributes(new DERObjectIdentifier(OID), value, type);
    }

    public void addSubjectDirectoryAttribute(String OID, Integer value) throws PKIException {
        if (!this.isHaveAttribute) {
            this.isHaveAttribute = true;
        }
        this.addAttributes(new DERObjectIdentifier(OID), value, (short)-1);
    }

    public void addSubjectDirectoryAttribute(String OID, byte[] value, short type) throws PKIException {
        if (!this.isHaveAttribute) {
            this.isHaveAttribute = true;
        }
        this.addAttributes(new DERObjectIdentifier(OID), value, type);
    }

    public void addSubjectDirectoryAttribute(String OID, Boolean value) throws PKIException {
        if (!this.isHaveAttribute) {
            this.isHaveAttribute = true;
        }
        this.addAttributes(new DERObjectIdentifier(OID), value, (short)-1);
    }

    public void addSubjectDirectoryAttribute(String OID, Date value, short type) throws PKIException {
        if (!this.isHaveAttribute) {
            this.isHaveAttribute = true;
        }
        this.addAttributes(new DERObjectIdentifier(OID), value, type);
    }

    public byte[] encode() throws PKIException {
        if (!this.isHaveAttribute) {
            throw new PKIException("850503", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        ASN1SequenceExt subjectDirectoryAttributes = new ASN1SequenceExt();
        Iterator ValuesItr = this.AttrMap.values().iterator();
        Iterator KeyItr = this.AttrMap.keySet().iterator();
        while (KeyItr.hasNext()) {
            ASN1SequenceExt seq_attr = new ASN1SequenceExt();
            seq_attr.addObject((DERObjectIdentifier)KeyItr.next());
            seq_attr.addObject(new DERSet((DEREncodableVector)ValuesItr.next()));
            subjectDirectoryAttributes.addObject(seq_attr);
        }
        return new DEROctetString(new SubjectDirectoryAttributes(subjectDirectoryAttributes).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    private void addAttributes(DERObjectIdentifier attrType, Object value, short type) throws PKIException {
        DEREncodableVector derEncodableVector = null;
        if (this.AttrMap.containsKey(attrType)) {
            derEncodableVector = (DEREncodableVector)this.AttrMap.get(attrType);
            derEncodableVector.add(this.TypeConversion(value, type));
        } else {
            derEncodableVector = new DEREncodableVector();
            derEncodableVector.add(this.TypeConversion(value, type));
            this.AttrMap.put(attrType, derEncodableVector);
        }
    }

    private void addAttributes(DERObjectIdentifier attrType, byte[] value, short type) throws PKIException {
        ASN1EncodableVector derEncodableVector = null;
        if (this.AttrMap.containsKey(attrType)) {
            derEncodableVector = (ASN1EncodableVector)this.AttrMap.get(attrType);
            derEncodableVector.add(this.TypeConversion(value, type));
        } else {
            derEncodableVector = new ASN1EncodableVector();
            derEncodableVector.add(this.TypeConversion(value, type));
            this.AttrMap.put(attrType, derEncodableVector);
        }
    }

    private DEREncodable TypeConversion(Object value, short Type2) throws PKIException {
        ASN1Object derencodable = null;
        if (value instanceof Integer) {
            derencodable = new DERInteger((Integer)value);
        } else if (value instanceof Boolean) {
            derencodable = new DERBoolean((Boolean)value);
        } else if (value instanceof Date) {
            if (Type2 == 0) {
                derencodable = new DERUTCTime((Date)value);
            } else if (Type2 == 1) {
                derencodable = new DERGeneralizedTime((Date)value);
            }
        } else if (value instanceof String) {
            if (Type2 == 0) {
                derencodable = new DERUTCTime((String)value);
            } else if (Type2 == 1) {
                derencodable = new DERGeneralizedTime((String)value);
            } else if (Type2 == 3) {
                derencodable = new DERPrintableString((String)value);
            } else if (Type2 == 4) {
                derencodable = new DERBMPString((String)value);
            } else if (Type2 == 5) {
                derencodable = new DERIA5String((String)value);
            } else if (Type2 == 6) {
                derencodable = new DERNumericString((String)value);
            } else if (Type2 == 8) {
                derencodable = new DERT61String((String)value);
            } else if (Type2 == 10) {
                derencodable = new DERUTF8String((String)value);
            } else if (Type2 == 11) {
                derencodable = new DERVisibleString((String)value);
            }
        }
        if (derencodable == null) {
            throw new PKIException("850504", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
        }
        return derencodable;
    }

    private DEREncodable TypeConversion(byte[] value, short Type2) throws PKIException {
        ASN1Object derencodable = null;
        if (Type2 == 2) {
            derencodable = new DERBitString(value);
        } else if (Type2 == 3) {
            derencodable = new DERPrintableString(value);
        } else if (Type2 == 4) {
            derencodable = new DERBMPString(value);
        } else if (Type2 == 5) {
            derencodable = new DERIA5String(value);
        } else if (Type2 == 6) {
            derencodable = new DERNumericString(value);
        } else if (Type2 == 7) {
            derencodable = new DEROctetString(value);
        } else if (Type2 == 8) {
            derencodable = new DERT61String(value);
        } else if (Type2 == 9) {
            derencodable = new DERUniversalString(value);
        } else if (Type2 == 11) {
            derencodable = new DERVisibleString(value);
        }
        if (derencodable == null) {
            throw new PKIException("850504", "\u6269\u5c55\u57df\u7684\u6570\u636e\u7c7b\u578b\u5728\u8be5\u65b9\u6cd5\u4e2d\u4e0d\u652f\u6301");
        }
        return derencodable;
    }
}

