/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROutputStream;
import com.cfca.util.pki.asn1.ocsp.BasicOCSPResponse;
import com.cfca.util.pki.asn1.ocsp.ResponseData;
import com.cfca.util.pki.asn1.ocsp.SingleResponse;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.ocsp.RespData;
import com.cfca.util.pki.ocsp.RespID;
import com.cfca.util.pki.ocsp.SingleResp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509Extension;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class BasicOCSPResp
implements X509Extension {
    BasicOCSPResponse resp;
    ResponseData data;
    X509Cert[] chain = null;

    public BasicOCSPResp(BasicOCSPResponse resp) {
        this.resp = resp;
        this.data = resp.getTbsResponseData();
    }

    public byte[] getTBSResponseData() throws PKIException {
        try {
            return this.resp.getTbsResponseData().getEncoded();
        }
        catch (IOException e) {
            throw new PKIException("850815", "\u83b7\u5f97TBCResponseData\u5931\u8d25", e);
        }
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() throws PKIException {
        try {
            return this.data.getProducedAt().getDate();
        }
        catch (ParseException e) {
            throw new PKIException("850816", "\u83b7\u5f97ProducedAt\u5931\u8d25", e);
        }
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        int i = 0;
        while (i != rs.length) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
            ++i;
        }
        return rs;
    }

    public X509Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.getResponseExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                com.cfca.util.pki.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
        }
        return set;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        com.cfca.util.pki.asn1.x509.X509Extension ext;
        X509Extensions exts = this.getResponseExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            try {
                dOut.writeObject(ext.getValue());
                return bOut.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws PKIException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this.resp);
        }
        catch (IOException ex) {
            throw new PKIException("850805", "\u83b7\u5f97\u57fa\u672cOCSP\u54cd\u5e94\u7684\u7f16\u7801\u5931\u8d25", ex);
        }
        return bOut.toByteArray();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicOCSPResp)) {
            return false;
        }
        BasicOCSPResp r = (BasicOCSPResp)o;
        return this.resp.equals(r.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }

    public String getSignatureAlgOID() {
        return this.resp.getSignatureAlgorithm().getObjectId().getId();
    }

    public RespData getResponseData() {
        return new RespData(this.resp.getTbsResponseData());
    }

    public byte[] getSignature() {
        return this.resp.getSignature().getBytes();
    }

    public X509Cert[] getCerts() throws PKIException {
        if (this.chain == null) {
            ArrayList<X509Cert> certs = new ArrayList<X509Cert>();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            ASN1Sequence s = this.resp.getCerts();
            if (s != null) {
                Enumeration e = s.getObjects();
                while (e.hasMoreElements()) {
                    try {
                        aOut.writeObject(e.nextElement());
                        certs.add(new X509Cert(new ByteArrayInputStream(bOut.toByteArray())));
                    }
                    catch (Exception ex) {
                        throw new PKIException("850807", "\u4eceOCSP\u54cd\u5e94\u4e2d\u83b7\u5f97\u8bc1\u4e66\u5931\u8d25", ex);
                    }
                    bOut.reset();
                }
            }
            this.chain = certs.toArray(new X509Cert[certs.size()]);
        }
        return this.chain;
    }

    public boolean verify(JKey key, Session session) throws PKIException {
        try {
            String strAlgOID = this.getSignatureAlgOID();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.resp.getTbsResponseData());
            Mechanism mechanism = null;
            if (strAlgOID.equalsIgnoreCase(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
                mechanism = new Mechanism("SHA1withRSAEncryption");
            } else if (strAlgOID.equalsIgnoreCase(PKCSObjectIdentifiers.md2WithRSAEncryption.getId())) {
                mechanism = new Mechanism("MD2withRSAEncryption");
            } else if (strAlgOID.equalsIgnoreCase(PKCSObjectIdentifiers.md5WithRSAEncryption.getId())) {
                mechanism = new Mechanism("MD5withRSAEncryption");
            } else {
                throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
            }
            return session.verifySign(mechanism, key, bOut.toByteArray(), this.getSignature());
        }
        catch (Exception e) {
            throw new PKIException("850806", "\u9a8c\u8bc1OCSP\u54cd\u5e94\u7684\u7b7e\u540d\u5931\u8d25", e);
        }
    }
}

