/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.ocsp.BasicOCSPResponse;
import com.cfca.util.pki.asn1.ocsp.OCSPObjectIdentifiers;
import com.cfca.util.pki.asn1.ocsp.OCSPResponse;
import com.cfca.util.pki.asn1.ocsp.ResponseBytes;
import com.cfca.util.pki.ocsp.BasicOCSPResp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class OCSPResp {
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse resp) {
        this.resp = resp;
    }

    public OCSPResp(byte[] resp) throws PKIException {
        this(new ASN1InputStream(resp));
    }

    public OCSPResp(InputStream in) throws PKIException {
        this(new ASN1InputStream(in));
    }

    private OCSPResp(ASN1InputStream aIn) throws PKIException {
        try {
            this.resp = OCSPResponse.getInstance(aIn.readObject());
        }
        catch (IllegalArgumentException e) {
            throw new PKIException("850819", "\u6784\u9020OCSP Resp\u5931\u8d25", e);
        }
        catch (IOException e) {
            throw new PKIException("850819", "\u6784\u9020OCSP Resp\u5931\u8d25", e);
        }
        catch (ClassCastException e) {
            throw new PKIException("850819", "\u6784\u9020OCSP Resp\u5931\u8d25", e);
        }
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws PKIException {
        ResponseBytes rb = this.resp.getResponseBytes();
        if (rb == null) {
            return null;
        }
        if (rb.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(rb.getResponse().getOctets()));
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(aIn.readObject()));
            }
            catch (Exception e) {
                throw new PKIException("850814", "\u4ece\u8bc1\u4e66\u72b6\u6001\u67e5\u8be2\u54cd\u5e94\u4e2d,\u83b7\u5f97\u57fa\u672c\u54cd\u5e94\u5931\u8d25", e);
            }
        }
        return rb.getResponse();
    }

    public byte[] getEncoded() throws PKIException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this.resp);
        }
        catch (Exception ex) {
            throw new PKIException("850813", "\u83b7\u5f97OCSP\u54cd\u5e94\u7684\u7f16\u7801\u5931\u8d25", ex);
        }
        return bOut.toByteArray();
    }
}

