/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DERGeneralizedTime;
import com.cfca.util.pki.asn1.ocsp.RevokedInfo;
import com.cfca.util.pki.asn1.x509.CRLReason;
import com.cfca.util.pki.ocsp.CertificateStatus;
import java.text.ParseException;
import java.util.Date;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(Date revocationTime, int crlReason) {
        DERGeneralizedTime time = new DERGeneralizedTime(revocationTime);
        CRLReason reason = new CRLReason(crlReason);
        this.info = new RevokedInfo(time, reason);
    }

    public RevokedStatus(RevokedInfo info) {
        this.info = info;
    }

    public Date getRevocationTime() throws PKIException {
        try {
            return this.info.getRevocationTime().getDate();
        }
        catch (ParseException e) {
            throw new PKIException("850820", "\u83b7\u5f97\u6ce8\u9500\u65f6\u95f4\u5931\u8d25", e);
        }
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

