/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.pkcs;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.JKeyPair;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.param.PBEParam;

public class PKCS8 {
    private Session session;

    public PKCS8(Session session) {
        this.session = session;
    }

    public byte[] generateEPKI(JKey prvKey, char[] password) throws PKIException {
        if (prvKey.getKeyType() != "RSA_Private") {
            throw new PKIException("850612", "\u4ea7\u751fPKCS8\u52a0\u5bc6\u79c1\u94a5\u4fe1\u606f\uff0c\u79c1\u94a5\u7c7b\u578b\u4e0d\u652f\u6301 : " + prvKey.getKeyType());
        }
        byte[] keyData = prvKey.getKey();
        PBEParam pbeParam = new PBEParam();
        byte[] salt = pbeParam.getSalt();
        int iterations = pbeParam.getIterations();
        Mechanism keyGenM = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        JKey pbeKey = this.session.generatePBEKey(keyGenM, password);
        Mechanism encryptM = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", pbeParam);
        byte[] encryptedData = this.session.encrypt(encryptM, pbeKey, keyData);
        ASN1EncodableVector derV = new ASN1EncodableVector();
        DEROctetString derO = new DEROctetString(salt);
        DERInteger derI = new DERInteger(iterations);
        derV.add(derO);
        derV.add(derI);
        DERSequence derS = new DERSequence(derV);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC, derS);
        EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(algId, encryptedData);
        return Parser.writeDERObj2Bytes(epki);
    }

    public JKey decodeEPKI(byte[] epkiData, char[] password) throws PKIException {
        ASN1Sequence asn1Seq = (ASN1Sequence)Parser.writeBytes2DERObj(epkiData);
        EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(asn1Seq);
        AlgorithmIdentifier algId = epki.getEncryptionAlgorithm();
        if (!algId.getObjectId().equals(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC)) {
            throw new PKIException("850613", "\u89e3\u6790PKCS8\u52a0\u5bc6\u79c1\u94a5\u4fe1\u606f\uff0c\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u652f\u6301 : " + algId.getObjectId().getId());
        }
        ASN1Sequence asn1Seq2 = (ASN1Sequence)algId.getParameters();
        ASN1OctetString asn1Oct = (ASN1OctetString)asn1Seq2.getObjectAt(0);
        DERInteger derInt = (DERInteger)asn1Seq2.getObjectAt(1);
        byte[] salt = asn1Oct.getOctets();
        int iterations = derInt.getValue().intValue();
        PBEParam pbeParam = new PBEParam();
        pbeParam.setSalt(salt);
        pbeParam.setIterations(iterations);
        Mechanism keyGenM = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        JKey pbeKey = this.session.generatePBEKey(keyGenM, password);
        Mechanism decryptM = new Mechanism("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", pbeParam);
        byte[] encryptedData = epki.getEncryptedData();
        byte[] keyData = this.session.decrypt(decryptM, pbeKey, encryptedData);
        return new JKey("RSA_Private", keyData);
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            JKeyPair keyPair = session.generateKeyPair(new Mechanism("RSA"), 1024);
            JKey priKey = keyPair.getPrivateKey();
            byte[] priKeyData = priKey.getKey();
            PKCS8 p8 = new PKCS8(session);
            byte[] encryptedKey = p8.generateEPKI(priKey, "1234567".toCharArray());
            JKey decryptedPriKey = p8.decodeEPKI(encryptedKey, "1234567".toCharArray());
            byte[] decryptKeyData = decryptedPriKey.getKey();
            if (Parser.isEqualArray(priKeyData, decryptKeyData)) {
                System.out.println("OK");
            } else {
                System.out.println("ERROR");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }
}

