/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.client.protocol;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestInterceptor;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        if (!httpRequest.containsHeader("Expect") && httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpClientContext httpClientContext;
            RequestConfig requestConfig;
            ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
            HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            if (httpEntity != null && httpEntity.getContentLength() != 0L && !protocolVersion.lessEquals(HttpVersion.HTTP_1_0) && (requestConfig = (httpClientContext = HttpClientContext.adapt(httpContext)).getRequestConfig()).isExpectContinueEnabled()) {
                httpRequest.addHeader("Expect", "100-continue");
            }
        }
    }
}

