/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl;

import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.ReasonPhraseCatalog;
import com.icbc.api.internal.apache.http.StatusLine;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.impl.EnglishReasonPhraseCatalog;
import com.icbc.api.internal.apache.http.message.BasicHttpResponse;
import com.icbc.api.internal.apache.http.message.BasicStatusLine;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog reasonPhraseCatalog) {
        this.reasonCatalog = Args.notNull(reasonPhraseCatalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion protocolVersion, int n, HttpContext httpContext) {
        Args.notNull(protocolVersion, "HTTP version");
        Locale locale = this.determineLocale(httpContext);
        String string = this.reasonCatalog.getReason(n, locale);
        BasicStatusLine basicStatusLine = new BasicStatusLine(protocolVersion, n, string);
        return new BasicHttpResponse(basicStatusLine, this.reasonCatalog, locale);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusLine, HttpContext httpContext) {
        Args.notNull(statusLine, "Status line");
        return new BasicHttpResponse(statusLine, this.reasonCatalog, this.determineLocale(httpContext));
    }

    protected Locale determineLocale(HttpContext httpContext) {
        return Locale.getDefault();
    }
}

