/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.auth;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.auth.AuthOption;
import com.icbc.api.internal.apache.http.auth.AuthProtocolState;
import com.icbc.api.internal.apache.http.auth.AuthScheme;
import com.icbc.api.internal.apache.http.auth.AuthState;
import com.icbc.api.internal.apache.http.auth.AuthenticationException;
import com.icbc.api.internal.apache.http.auth.ContextAwareAuthScheme;
import com.icbc.api.internal.apache.http.auth.Credentials;
import com.icbc.api.internal.apache.http.auth.MalformedChallengeException;
import com.icbc.api.internal.apache.http.client.AuthenticationStrategy;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpAuthenticator {
    private final Log log;

    public HttpAuthenticator(Log log) {
        this.log = log != null ? log : LogFactory.getLog(this.getClass());
    }

    public HttpAuthenticator() {
        this(null);
    }

    public boolean isAuthenticationRequested(HttpHost httpHost, HttpResponse httpResponse, AuthenticationStrategy authenticationStrategy, AuthState authState, HttpContext httpContext) {
        if (authenticationStrategy.isAuthenticationRequested(httpHost, httpResponse, httpContext)) {
            this.log.debug((Object)"Authentication required");
            if (authState.getState() == AuthProtocolState.SUCCESS) {
                authenticationStrategy.authFailed(httpHost, authState.getAuthScheme(), httpContext);
            }
            return true;
        }
        switch (authState.getState()) {
            case CHALLENGED: 
            case HANDSHAKE: {
                this.log.debug((Object)"Authentication succeeded");
                authState.setState(AuthProtocolState.SUCCESS);
                authenticationStrategy.authSucceeded(httpHost, authState.getAuthScheme(), httpContext);
                break;
            }
            case SUCCESS: {
                break;
            }
            default: {
                authState.setState(AuthProtocolState.UNCHALLENGED);
            }
        }
        return false;
    }

    public boolean handleAuthChallenge(HttpHost httpHost, HttpResponse httpResponse, AuthenticationStrategy authenticationStrategy, AuthState authState, HttpContext httpContext) {
        try {
            Object object;
            Map<String, Header> map;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(httpHost.toHostString() + " requested authentication"));
            }
            if ((map = authenticationStrategy.getChallenges(httpHost, httpResponse, httpContext)).isEmpty()) {
                this.log.debug((Object)"Response contains no authentication challenges");
                return false;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            switch (authState.getState()) {
                case FAILURE: {
                    return false;
                }
                case SUCCESS: {
                    authState.reset();
                    break;
                }
                case CHALLENGED: 
                case HANDSHAKE: {
                    if (authScheme == null) {
                        this.log.debug((Object)"Auth scheme is null");
                        authenticationStrategy.authFailed(httpHost, null, httpContext);
                        authState.reset();
                        authState.setState(AuthProtocolState.FAILURE);
                        return false;
                    }
                }
                case UNCHALLENGED: {
                    if (authScheme == null) break;
                    object = authScheme.getSchemeName();
                    Header header = map.get(((String)object).toLowerCase(Locale.ROOT));
                    if (header != null) {
                        this.log.debug((Object)"Authorization challenge processed");
                        authScheme.processChallenge(header);
                        if (authScheme.isComplete()) {
                            this.log.debug((Object)"Authentication failed");
                            authenticationStrategy.authFailed(httpHost, authState.getAuthScheme(), httpContext);
                            authState.reset();
                            authState.setState(AuthProtocolState.FAILURE);
                            return false;
                        }
                        authState.setState(AuthProtocolState.HANDSHAKE);
                        return true;
                    }
                    authState.reset();
                }
            }
            object = authenticationStrategy.select(map, httpHost, httpResponse, httpContext);
            if (object != null && !object.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Selected authentication options: " + object));
                }
                authState.setState(AuthProtocolState.CHALLENGED);
                authState.update((Queue<AuthOption>)object);
                return true;
            }
            return false;
        }
        catch (MalformedChallengeException malformedChallengeException) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Malformed challenge: " + malformedChallengeException.getMessage()));
            }
            authState.reset();
            return false;
        }
    }

    public void generateAuthResponse(HttpRequest httpRequest, AuthState authState, HttpContext httpContext) throws HttpException, IOException {
        block13: {
            Object object;
            AuthScheme authScheme = authState.getAuthScheme();
            Credentials credentials = authState.getCredentials();
            switch (authState.getState()) {
                case FAILURE: {
                    return;
                }
                case SUCCESS: {
                    this.ensureAuthScheme(authScheme);
                    if (!authScheme.isConnectionBased()) break;
                    return;
                }
                case CHALLENGED: {
                    object = authState.getAuthOptions();
                    if (object != null) {
                        while (!object.isEmpty()) {
                            AuthOption authOption = object.remove();
                            authScheme = authOption.getAuthScheme();
                            credentials = authOption.getCredentials();
                            authState.update(authScheme, credentials);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Generating response to an authentication challenge using " + authScheme.getSchemeName() + " scheme"));
                            }
                            try {
                                Header header = this.doAuth(authScheme, credentials, httpRequest, httpContext);
                                httpRequest.addHeader(header);
                                break;
                            }
                            catch (AuthenticationException authenticationException) {
                                if (!this.log.isWarnEnabled()) continue;
                                this.log.warn((Object)(authScheme + " authentication error: " + authenticationException.getMessage()));
                            }
                        }
                        return;
                    }
                    this.ensureAuthScheme(authScheme);
                }
            }
            if (authScheme != null) {
                try {
                    object = this.doAuth(authScheme, credentials, httpRequest, httpContext);
                    httpRequest.addHeader((Header)object);
                }
                catch (AuthenticationException authenticationException) {
                    if (!this.log.isErrorEnabled()) break block13;
                    this.log.error((Object)(authScheme + " authentication error: " + authenticationException.getMessage()));
                }
            }
        }
    }

    private void ensureAuthScheme(AuthScheme authScheme) {
        Asserts.notNull(authScheme, "Auth scheme");
    }

    private Header doAuth(AuthScheme authScheme, Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        if (authScheme instanceof ContextAwareAuthScheme) {
            return ((ContextAwareAuthScheme)authScheme).authenticate(credentials, httpRequest, httpContext);
        }
        return authScheme.authenticate(credentials, httpRequest);
    }
}

