/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.client;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.auth.AuthScheme;
import com.icbc.api.internal.apache.http.auth.AuthState;
import com.icbc.api.internal.apache.http.auth.Credentials;
import com.icbc.api.internal.apache.http.client.UserTokenHandler;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.conn.ManagedHttpClientConnection;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext httpContext) {
        SSLSession sSLSession;
        Object object;
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        Principal principal = null;
        AuthState authState = httpClientContext.getTargetAuthState();
        if (authState != null && (principal = DefaultUserTokenHandler.getAuthPrincipal(authState)) == null) {
            object = httpClientContext.getProxyAuthState();
            principal = DefaultUserTokenHandler.getAuthPrincipal((AuthState)object);
        }
        if (principal == null && (object = httpClientContext.getConnection()).isOpen() && object instanceof ManagedHttpClientConnection && (sSLSession = ((ManagedHttpClientConnection)object).getSSLSession()) != null) {
            principal = sSLSession.getLocalPrincipal();
        }
        return principal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials credentials;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme != null && authScheme.isComplete() && authScheme.isConnectionBased() && (credentials = authState.getCredentials()) != null) {
            return credentials.getUserPrincipal();
        }
        return null;
    }
}

