/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.NoHttpResponseException;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.StatusLine;
import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.io.AbstractMessageParser;
import com.icbc.api.internal.apache.http.io.SessionInputBuffer;
import com.icbc.api.internal.apache.http.message.LineParser;
import com.icbc.api.internal.apache.http.message.ParserCursor;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpResponseFactory httpResponseFactory, HttpParams httpParams) {
        super(sessionInputBuffer, lineParser, httpParams);
        Args.notNull(httpResponseFactory, "Response factory");
        this.responseFactory = httpResponseFactory;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpResponseFactory httpResponseFactory, MessageConstraints messageConstraints) {
        super(sessionInputBuffer, lineParser, messageConstraints);
        this.responseFactory = httpResponseFactory != null ? httpResponseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer sessionInputBuffer, MessageConstraints messageConstraints) {
        this(sessionInputBuffer, null, null, messageConstraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer sessionInputBuffer) {
        this(sessionInputBuffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionInputBuffer) throws IOException, HttpException {
        int n = 0;
        ParserCursor parserCursor = null;
        while (true) {
            this.lineBuf.clear();
            int n2 = sessionInputBuffer.readLine(this.lineBuf);
            if (n2 == -1 && n == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            parserCursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, parserCursor)) break;
            if (n2 == -1 || this.reject(this.lineBuf, n)) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Garbage in response: " + this.lineBuf.toString()));
            }
            ++n;
        }
        StatusLine statusLine = this.lineParser.parseStatusLine(this.lineBuf, parserCursor);
        return this.responseFactory.newHttpResponse(statusLine, null);
    }

    protected boolean reject(CharArrayBuffer charArrayBuffer, int n) {
        return false;
    }
}

