/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.conn.SchemePortResolver;
import com.icbc.api.internal.apache.http.conn.UnsupportedSchemeException;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoutePlanner;
import com.icbc.api.internal.apache.http.impl.conn.DefaultSchemePortResolver;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.net.InetAddress;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        HttpHost httpHost2;
        Args.notNull(httpRequest, "Request");
        if (httpHost == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        InetAddress inetAddress = requestConfig.getLocalAddress();
        HttpHost httpHost3 = requestConfig.getProxy();
        if (httpHost3 == null) {
            httpHost3 = this.determineProxy(httpHost, httpRequest, httpContext);
        }
        if (httpHost.getPort() <= 0) {
            try {
                httpHost2 = new HttpHost(httpHost.getHostName(), this.schemePortResolver.resolve(httpHost), httpHost.getSchemeName());
            }
            catch (UnsupportedSchemeException unsupportedSchemeException) {
                throw new HttpException(unsupportedSchemeException.getMessage());
            }
        } else {
            httpHost2 = httpHost;
        }
        boolean bl = httpHost2.getSchemeName().equalsIgnoreCase("https");
        if (httpHost3 == null) {
            return new HttpRoute(httpHost2, inetAddress, bl);
        }
        return new HttpRoute(httpHost2, inetAddress, httpHost3, bl);
    }

    protected HttpHost determineProxy(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        return null;
    }
}

