/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import com.icbc.api.internal.apache.http.impl.conn.LoggingInputStream;
import com.icbc.api.internal.apache.http.impl.conn.LoggingOutputStream;
import com.icbc.api.internal.apache.http.impl.conn.Wire;
import com.icbc.api.internal.apache.http.io.HttpMessageParserFactory;
import com.icbc.api.internal.apache.http.io.HttpMessageWriterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.logging.Log;

@NotThreadSafe
class LoggingManagedHttpClientConnection
extends DefaultManagedHttpClientConnection {
    private final Log log;
    private final Log headerlog;
    private final Wire wire;

    public LoggingManagedHttpClientConnection(String string, Log log, Log log2, Log log3, int n, int n2, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, HttpMessageWriterFactory<HttpRequest> httpMessageWriterFactory, HttpMessageParserFactory<HttpResponse> httpMessageParserFactory) {
        super(string, n, n2, charsetDecoder, charsetEncoder, messageConstraints, contentLengthStrategy, contentLengthStrategy2, httpMessageWriterFactory, httpMessageParserFactory);
        this.log = log;
        this.headerlog = log2;
        this.wire = new Wire(log3, string);
    }

    @Override
    public void close() throws IOException {
        if (super.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.getId() + ": Close connection"));
            }
            super.close();
        }
    }

    @Override
    public void setSocketTimeout(int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getId() + ": set socket timeout to " + n));
        }
        super.setSocketTimeout(n);
    }

    @Override
    public void shutdown() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getId() + ": Shutdown connection"));
        }
        super.shutdown();
    }

    @Override
    protected InputStream getSocketInputStream(Socket socket) throws IOException {
        InputStream inputStream = super.getSocketInputStream(socket);
        if (this.wire.enabled()) {
            inputStream = new LoggingInputStream(inputStream, this.wire);
        }
        return inputStream;
    }

    @Override
    protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
        OutputStream outputStream = super.getSocketOutputStream(socket);
        if (this.wire.enabled()) {
            outputStream = new LoggingOutputStream(outputStream, this.wire);
        }
        return outputStream;
    }

    @Override
    protected void onResponseReceived(HttpResponse httpResponse) {
        if (httpResponse != null && this.headerlog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerlog.debug((Object)(this.getId() + " << " + httpResponse.getStatusLine().toString()));
            for (Header header : headerArray = httpResponse.getAllHeaders()) {
                this.headerlog.debug((Object)(this.getId() + " << " + header.toString()));
            }
        }
    }

    @Override
    protected void onRequestSubmitted(HttpRequest httpRequest) {
        if (httpRequest != null && this.headerlog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerlog.debug((Object)(this.getId() + " >> " + httpRequest.getRequestLine().toString()));
            for (Header header : headerArray = httpRequest.getAllHeaders()) {
                this.headerlog.debug((Object)(this.getId() + " >> " + header.toString()));
            }
        }
    }
}

