/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn.tsccm;

import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.conn.ClientConnectionManager;
import com.icbc.api.internal.apache.http.conn.ClientConnectionOperator;
import com.icbc.api.internal.apache.http.conn.ClientConnectionRequest;
import com.icbc.api.internal.apache.http.conn.ConnectionPoolTimeoutException;
import com.icbc.api.internal.apache.http.conn.ManagedClientConnection;
import com.icbc.api.internal.apache.http.conn.params.ConnPerRouteBean;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.scheme.SchemeRegistry;
import com.icbc.api.internal.apache.http.impl.conn.AbstractPoolEntry;
import com.icbc.api.internal.apache.http.impl.conn.DefaultClientConnectionOperator;
import com.icbc.api.internal.apache.http.impl.conn.SchemeRegistryFactory;
import com.icbc.api.internal.apache.http.impl.conn.tsccm.AbstractConnPool;
import com.icbc.api.internal.apache.http.impl.conn.tsccm.BasicPoolEntry;
import com.icbc.api.internal.apache.http.impl.conn.tsccm.BasicPooledConnAdapter;
import com.icbc.api.internal.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import com.icbc.api.internal.apache.http.impl.conn.tsccm.PoolEntryRequest;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
@ThreadSafe
public class ThreadSafeClientConnManager
implements ClientConnectionManager {
    private final Log log;
    protected final SchemeRegistry schemeRegistry;
    protected final AbstractConnPool connectionPool;
    protected final ConnPoolByRoute pool;
    protected final ClientConnectionOperator connOperator;
    protected final ConnPerRouteBean connPerRoute;

    public ThreadSafeClientConnManager(SchemeRegistry schemeRegistry) {
        this(schemeRegistry, -1L, TimeUnit.MILLISECONDS);
    }

    public ThreadSafeClientConnManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    public ThreadSafeClientConnManager(SchemeRegistry schemeRegistry, long l, TimeUnit timeUnit) {
        this(schemeRegistry, l, timeUnit, new ConnPerRouteBean());
    }

    public ThreadSafeClientConnManager(SchemeRegistry schemeRegistry, long l, TimeUnit timeUnit, ConnPerRouteBean connPerRouteBean) {
        Args.notNull(schemeRegistry, "Scheme registry");
        this.log = LogFactory.getLog(this.getClass());
        this.schemeRegistry = schemeRegistry;
        this.connPerRoute = connPerRouteBean;
        this.connOperator = this.createConnectionOperator(schemeRegistry);
        this.pool = this.createConnectionPool(l, timeUnit);
        this.connectionPool = this.pool;
    }

    @Deprecated
    public ThreadSafeClientConnManager(HttpParams httpParams, SchemeRegistry schemeRegistry) {
        Args.notNull(schemeRegistry, "Scheme registry");
        this.log = LogFactory.getLog(this.getClass());
        this.schemeRegistry = schemeRegistry;
        this.connPerRoute = new ConnPerRouteBean();
        this.connOperator = this.createConnectionOperator(schemeRegistry);
        this.pool = (ConnPoolByRoute)this.createConnectionPool(httpParams);
        this.connectionPool = this.pool;
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Deprecated
    protected AbstractConnPool createConnectionPool(HttpParams httpParams) {
        return new ConnPoolByRoute(this.connOperator, httpParams);
    }

    protected ConnPoolByRoute createConnectionPool(long l, TimeUnit timeUnit) {
        return new ConnPoolByRoute(this.connOperator, this.connPerRoute, 20, l, timeUnit);
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schemeRegistry) {
        return new DefaultClientConnectionOperator(schemeRegistry);
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    @Override
    public ClientConnectionRequest requestConnection(final HttpRoute httpRoute, Object object) {
        final PoolEntryRequest poolEntryRequest = this.pool.requestPoolEntry(httpRoute, object);
        return new ClientConnectionRequest(){

            @Override
            public void abortRequest() {
                poolEntryRequest.abortRequest();
            }

            @Override
            public ManagedClientConnection getConnection(long l, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
                Args.notNull(httpRoute, "Route");
                if (ThreadSafeClientConnManager.this.log.isDebugEnabled()) {
                    ThreadSafeClientConnManager.this.log.debug((Object)("Get connection: " + httpRoute + ", timeout = " + l));
                }
                BasicPoolEntry basicPoolEntry = poolEntryRequest.getPoolEntry(l, timeUnit);
                return new BasicPooledConnAdapter(ThreadSafeClientConnManager.this, (AbstractPoolEntry)basicPoolEntry);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(ManagedClientConnection managedClientConnection, long l, TimeUnit timeUnit) {
        Args.check(managedClientConnection instanceof BasicPooledConnAdapter, "Connection class mismatch, connection not obtained from this manager");
        BasicPooledConnAdapter basicPooledConnAdapter = (BasicPooledConnAdapter)managedClientConnection;
        if (basicPooledConnAdapter.getPoolEntry() != null) {
            Asserts.check(basicPooledConnAdapter.getManager() == this, "Connection not obtained from this manager");
        }
        BasicPooledConnAdapter basicPooledConnAdapter2 = basicPooledConnAdapter;
        synchronized (basicPooledConnAdapter2) {
            BasicPoolEntry basicPoolEntry = (BasicPoolEntry)basicPooledConnAdapter.getPoolEntry();
            if (basicPoolEntry == null) {
                return;
            }
            try {
                if (basicPooledConnAdapter.isOpen() && !basicPooledConnAdapter.isMarkedReusable()) {
                    basicPooledConnAdapter.shutdown();
                }
            }
            catch (IOException iOException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Exception shutting down released connection.", (Throwable)iOException);
                }
            }
            finally {
                boolean bl = basicPooledConnAdapter.isMarkedReusable();
                if (this.log.isDebugEnabled()) {
                    if (bl) {
                        this.log.debug((Object)"Released connection is reusable.");
                    } else {
                        this.log.debug((Object)"Released connection is not reusable.");
                    }
                }
                basicPooledConnAdapter.detach();
                this.pool.freeEntry(basicPoolEntry, bl, l, timeUnit);
            }
        }
    }

    @Override
    public void shutdown() {
        this.log.debug((Object)"Shutting down");
        this.pool.shutdown();
    }

    public int getConnectionsInPool(HttpRoute httpRoute) {
        return this.pool.getConnectionsInPool(httpRoute);
    }

    public int getConnectionsInPool() {
        return this.pool.getConnectionsInPool();
    }

    @Override
    public void closeIdleConnections(long l, TimeUnit timeUnit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + l + " " + (Object)((Object)timeUnit)));
        }
        this.pool.closeIdleConnections(l, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpiredConnections();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotalConnections();
    }

    public void setMaxTotal(int n) {
        this.pool.setMaxTotalConnections(n);
    }

    public int getDefaultMaxPerRoute() {
        return this.connPerRoute.getDefaultMaxPerRoute();
    }

    public void setDefaultMaxPerRoute(int n) {
        this.connPerRoute.setDefaultMaxPerRoute(n);
    }

    public int getMaxForRoute(HttpRoute httpRoute) {
        return this.connPerRoute.getMaxForRoute(httpRoute);
    }

    public void setMaxForRoute(HttpRoute httpRoute, int n) {
        this.connPerRoute.setMaxForRoute(httpRoute, n);
    }
}

