/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.conn.util.InetAddressUtils;
import com.icbc.api.internal.apache.http.cookie.ClientCookie;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookieRestrictionViolationException;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.TextUtils;
import java.util.Locale;

@Immutable
public class BasicDomainHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (TextUtils.isBlank(string)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        if (string.endsWith(".")) {
            return;
        }
        String string2 = string;
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        string2 = string2.toLowerCase(Locale.ROOT);
        setCookie.setDomain(string2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        String string = cookieOrigin.getHost();
        String string2 = cookie.getDomain();
        if (string2 == null) {
            throw new CookieRestrictionViolationException("Cookie 'domain' may not be null");
        }
        if (!string.equals(string2) && !BasicDomainHandler.domainMatch(string2, string)) {
            throw new CookieRestrictionViolationException("Illegal 'domain' attribute \"" + string2 + "\". Domain of origin: \"" + string + "\"");
        }
    }

    static boolean domainMatch(String string, String string2) {
        String string3;
        if (InetAddressUtils.isIPv4Address(string2) || InetAddressUtils.isIPv6Address(string2)) {
            return false;
        }
        String string4 = string3 = string.startsWith(".") ? string.substring(1) : string;
        if (string2.endsWith(string3)) {
            int n = string2.length() - string3.length();
            if (n == 0) {
                return true;
            }
            if (n > 1 && string2.charAt(n - 1) == '.') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        String string = cookieOrigin.getHost();
        String string2 = cookie.getDomain();
        if (string2 == null) {
            return false;
        }
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        if (string.equals(string2 = string2.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            return BasicDomainHandler.domainMatch(string2, string);
        }
        return false;
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

