/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.utils.DateUtils;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.icbc.api.internal.apache.http.util.Args;
import java.util.Date;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] stringArray) {
        Args.notNull(stringArray, "Array of date patterns");
        this.datepatterns = stringArray;
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date date = DateUtils.parseDate(string, this.datepatterns);
        if (date == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + string);
        }
        setCookie.setExpiryDate(date);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

