/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HeaderElement;
import com.icbc.api.internal.apache.http.NameValuePair;
import com.icbc.api.internal.apache.http.annotation.Obsolete;
import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.cookie.ClientCookie;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.impl.cookie.BasicClientCookie2;
import com.icbc.api.internal.apache.http.impl.cookie.BasicCommentHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicExpiresHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicMaxAgeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicPathHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicSecureHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2109Spec;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965DomainAttributeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import com.icbc.api.internal.apache.http.message.BufferedHeader;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Obsolete
@ThreadSafe
public class RFC2965Spec
extends RFC2109Spec {
    public RFC2965Spec() {
        this(null, false);
    }

    public RFC2965Spec(String[] stringArray, boolean bl) {
        super(bl, new RFC2965VersionAttributeHandler(), new BasicPathHandler(), new RFC2965DomainAttributeHandler(), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new BasicExpiresHandler(stringArray != null ? (String[])stringArray.clone() : DATE_PATTERNS), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
    }

    RFC2965Spec(boolean bl, CommonCookieAttributeHandler ... commonCookieAttributeHandlerArray) {
        super(bl, commonCookieAttributeHandlerArray);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(header, "Header");
        Args.notNull(cookieOrigin, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie2")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] headerElementArray = header.getElements();
        return this.createCookies(headerElementArray, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    protected List<Cookie> parse(HeaderElement[] headerElementArray, CookieOrigin cookieOrigin) throws MalformedCookieException {
        return this.createCookies(headerElementArray, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    private List<Cookie> createCookies(HeaderElement[] headerElementArray, CookieOrigin cookieOrigin) throws MalformedCookieException {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(headerElementArray.length);
        for (HeaderElement headerElement : headerElementArray) {
            String string = headerElement.getName();
            String string2 = headerElement.getValue();
            if (string == null || string.isEmpty()) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie2 basicClientCookie2 = new BasicClientCookie2(string, string2);
            basicClientCookie2.setPath(RFC2965Spec.getDefaultPath(cookieOrigin));
            basicClientCookie2.setDomain(RFC2965Spec.getDefaultDomain(cookieOrigin));
            basicClientCookie2.setPorts(new int[]{cookieOrigin.getPort()});
            NameValuePair[] nameValuePairArray = headerElement.getParameters();
            HashMap<String, NameValuePair> hashMap = new HashMap<String, NameValuePair>(nameValuePairArray.length);
            for (int i = nameValuePairArray.length - 1; i >= 0; --i) {
                NameValuePair nameValuePair = nameValuePairArray[i];
                hashMap.put(nameValuePair.getName().toLowerCase(Locale.ROOT), nameValuePair);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                NameValuePair nameValuePair = (NameValuePair)entry.getValue();
                String string3 = nameValuePair.getName().toLowerCase(Locale.ROOT);
                basicClientCookie2.setAttribute(string3, nameValuePair.getValue());
                CookieAttributeHandler cookieAttributeHandler = this.findAttribHandler(string3);
                if (cookieAttributeHandler == null) continue;
                cookieAttributeHandler.parse(basicClientCookie2, nameValuePair.getValue());
            }
            arrayList.add(basicClientCookie2);
        }
        return arrayList;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        super.validate(cookie, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        return super.match(cookie, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    protected void formatCookieAsVer(CharArrayBuffer charArrayBuffer, Cookie cookie, int n) {
        String string;
        super.formatCookieAsVer(charArrayBuffer, cookie, n);
        if (cookie instanceof ClientCookie && (string = ((ClientCookie)cookie).getAttribute("port")) != null) {
            int[] nArray;
            charArrayBuffer.append("; $Port");
            charArrayBuffer.append("=\"");
            if (!string.trim().isEmpty() && (nArray = cookie.getPorts()) != null) {
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        charArrayBuffer.append(",");
                    }
                    charArrayBuffer.append(Integer.toString(nArray[i]));
                }
            }
            charArrayBuffer.append("\"");
        }
    }

    private static CookieOrigin adjustEffectiveHost(CookieOrigin cookieOrigin) {
        String string = cookieOrigin.getHost();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 != '.' && c2 != ':') continue;
            bl = false;
            break;
        }
        if (bl) {
            string = string + ".local";
            return new CookieOrigin(string, cookieOrigin.getPort(), cookieOrigin.getPath(), cookieOrigin.isSecure());
        }
        return cookieOrigin;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(40);
        charArrayBuffer.append("Cookie2");
        charArrayBuffer.append(": ");
        charArrayBuffer.append("$Version=");
        charArrayBuffer.append(Integer.toString(this.getVersion()));
        return new BufferedHeader(charArrayBuffer);
    }

    @Override
    public String toString() {
        return "rfc2965";
    }
}

