/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.cookie.ClientCookie;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookieRestrictionViolationException;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.cookie.SetCookie2;
import com.icbc.api.internal.apache.http.util.Args;

@Immutable
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        setCookie.setVersion(n);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

