/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpClientConnection;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import com.icbc.api.internal.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import com.icbc.api.internal.apache.http.impl.nio.reactor.AbstractIODispatch;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpClientIODispatch
extends AbstractIODispatch<DefaultNHttpClientConnection> {
    private final NHttpClientEventHandler handler;
    private final NHttpConnectionFactory<DefaultNHttpClientConnection> connFactory;

    public DefaultHttpClientIODispatch(NHttpClientEventHandler nHttpClientEventHandler, NHttpConnectionFactory<DefaultNHttpClientConnection> nHttpConnectionFactory) {
        this.handler = Args.notNull(nHttpClientEventHandler, "HTTP client handler");
        this.connFactory = Args.notNull(nHttpConnectionFactory, "HTTP client connection factory");
    }

    @Deprecated
    public DefaultHttpClientIODispatch(NHttpClientEventHandler nHttpClientEventHandler, HttpParams httpParams) {
        this(nHttpClientEventHandler, new DefaultNHttpClientConnectionFactory(httpParams));
    }

    @Deprecated
    public DefaultHttpClientIODispatch(NHttpClientEventHandler nHttpClientEventHandler, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, HttpParams httpParams) {
        this(nHttpClientEventHandler, new SSLNHttpClientConnectionFactory(sSLContext, sSLSetupHandler, httpParams));
    }

    @Deprecated
    public DefaultHttpClientIODispatch(NHttpClientEventHandler nHttpClientEventHandler, SSLContext sSLContext, HttpParams httpParams) {
        this(nHttpClientEventHandler, sSLContext, null, httpParams);
    }

    public DefaultHttpClientIODispatch(NHttpClientEventHandler nHttpClientEventHandler, ConnectionConfig connectionConfig) {
        this(nHttpClientEventHandler, new DefaultNHttpClientConnectionFactory(connectionConfig));
    }

    public DefaultHttpClientIODispatch(NHttpClientEventHandler nHttpClientEventHandler, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, ConnectionConfig connectionConfig) {
        this(nHttpClientEventHandler, new SSLNHttpClientConnectionFactory(sSLContext, sSLSetupHandler, connectionConfig));
    }

    public DefaultHttpClientIODispatch(NHttpClientEventHandler nHttpClientEventHandler, SSLContext sSLContext, ConnectionConfig connectionConfig) {
        this(nHttpClientEventHandler, new SSLNHttpClientConnectionFactory(sSLContext, null, connectionConfig));
    }

    @Override
    protected DefaultNHttpClientConnection createConnection(IOSession iOSession) {
        return this.connFactory.createConnection(iOSession);
    }

    @Override
    protected void onConnected(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        Object object = defaultNHttpClientConnection.getContext().getAttribute("http.session.attachment");
        try {
            this.handler.connected(defaultNHttpClientConnection, object);
        }
        catch (Exception exception) {
            this.handler.exception(defaultNHttpClientConnection, exception);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        this.handler.closed(defaultNHttpClientConnection);
    }

    @Override
    protected void onException(DefaultNHttpClientConnection defaultNHttpClientConnection, IOException iOException) {
        this.handler.exception(defaultNHttpClientConnection, iOException);
    }

    @Override
    protected void onInputReady(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        defaultNHttpClientConnection.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        defaultNHttpClientConnection.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        try {
            this.handler.timeout(defaultNHttpClientConnection);
        }
        catch (Exception exception) {
            this.handler.exception(defaultNHttpClientConnection, exception);
        }
    }
}

